/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.storage.uv;

import com.selima.fbi.CancelException;
import com.selima.fbi.loader.ILoaderFactory;
import com.selima.fbi.saver.ISaverFactory;
import com.selima.fbi.storage.IExtendedStorageFactorySPI;
import com.selima.fbi.storage.IStorable;
import com.selima.fbi.storage.IStorageSPI;
import com.selima.fbi.storage.StorageConfigParser;
import com.selima.fbi.storage.StorageId;
import com.selima.fbi.storage.StorageImpl;
import com.selima.fbi.storage.memory.InMemoryStorage;
import com.selima.fbi.storage.transfer.RawRecord;
import com.selima.fbi.storage.uv.IFileTypeProvider;
import com.selima.fbi.storage.uv.UvFilesAccess;
import com.selima.fbi.storage.uv.UvFilesAccessImpl;
import com.selima.fbi.storage.uv.UvNameEncoder;
import com.selima.fbi.storage.uv.UvStorageException;
import com.selima.fbi.storage.uv.UvStorageFileNames;
import com.selima.fbi.storage.uv.UvStorageProvider;
import com.selima.fbi.user.PayrollServerSpec;
import com.selima.framework.util.Util;
import com.selima.framework.util.logging.LogAPI;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class UvStorageFactorySPI
implements IExtendedStorageFactorySPI {
    private Map<String, String> properties;
    private ILoaderFactory loaderFactory;
    private ISaverFactory saverFactory;
    private PayrollServerSpec payrollServer;
    private UvFilesAccess filesAccess;

    public UvStorageFactorySPI(Map<String, String> properties, PayrollServerSpec serverSpec, ILoaderFactory loaderFactory, ISaverFactory saverFactory) {
        this.properties = properties;
        this.payrollServer = serverSpec;
        this.loaderFactory = loaderFactory;
        this.saverFactory = saverFactory;
        IFileTypeProvider fileTypeProvider = new IFileTypeProvider(){

            @Override
            public String getFileType(String fileName) {
                if (fileName.endsWith(".index")) {
                    return "25";
                }
                return "19";
            }
        };
        this.filesAccess = new UvFilesAccessImpl(serverSpec, fileTypeProvider);
    }

    public void initialize() throws UvStorageException, CancelException {
        this.filesAccess.initialize();
    }

    @Override
    public String getName() {
        return this.payrollServer.getHostOrLocalhost() + "(" + this.payrollServer.getAccount() + ")";
    }

    @Override
    public <T extends IStorable> IStorageSPI<T> createStorage(String alias, Class<T> type) throws UvStorageException {
        LogAPI.logFiner((String)("UvStorageFactorySPI.createStorage() begin: " + alias + "," + type.getSimpleName()));
        Properties config = StorageConfigParser.parse(this.properties, alias);
        if (config.isEmpty()) {
            InMemoryStorage<T> storage = new InMemoryStorage<T>(type);
            LogAPI.logWarning((String)("Storage '" + alias + "' not configured"));
            return storage;
        }
        UvStorageProvider provider = new UvStorageProvider(this.filesAccess, alias, config.getProperty("content-type", "xml"));
        StorageImpl<T> storage = new StorageImpl<T>(provider, this.loaderFactory.createLoader(type), this.saverFactory.createSaver(type), type);
        LogAPI.logFiner((String)"UvStorageFactorySPI.createStorage() end");
        return storage;
    }

    @Override
    public void begin() throws UvStorageException, CancelException {
        this.filesAccess.begin();
    }

    @Override
    public void commit() throws UvStorageException, CancelException {
        this.filesAccess.commit();
    }

    @Override
    public void rollback() throws UvStorageException, CancelException {
        this.filesAccess.rollback();
    }

    @Override
    public boolean isInTransaction() {
        return this.filesAccess.isInTransaction();
    }

    UvFilesAccess getFilesAccess() {
        return this.filesAccess;
    }

    @Override
    public void cancel() {
        this.filesAccess.cancel();
    }

    @Override
    public void deleteStorage(StorageId storageId) throws UvStorageException, CancelException {
        String alias = storageId.getAlias();
        String outerSpace = storageId.getOuterSpace();
        String innerSpace = storageId.getInnerSpace();
        LogAPI.logFiner((String)("UvStorageFactorySPI.deleteStorage() begin: " + alias + "," + outerSpace + "," + innerSpace));
        String dataFileName = UvStorageFileNames.createDataFileName(alias, outerSpace, innerSpace);
        this.filesAccess.deleteFile(dataFileName);
        String indexFileName = UvStorageFileNames.createIndexFileName(alias, outerSpace, innerSpace);
        this.filesAccess.deleteFile(indexFileName);
        LogAPI.logFiner((String)"UvStorageFactorySPI.deleteStorage() end");
    }

    @Override
    public StorageId[] listStorages() throws UvStorageException, CancelException {
        HashSet<StorageId> storageIds = new HashSet<StorageId>();
        String query = "SELECT VOC WITH @ID=\"FBI_]\"";
        List<String> fileNames = this.filesAccess.query(query);
        for (String fileName : fileNames) {
            String decodedFileName = UvNameEncoder.decodeFromOSFileName(fileName);
            StorageId storageId = UvStorageFileNames.createStorageId(decodedFileName);
            if (storageId == null) continue;
            storageIds.add(storageId);
        }
        return storageIds.toArray(new StorageId[0]);
    }

    @Override
    public boolean isSameLocation(IExtendedStorageFactorySPI factory) {
        if (factory instanceof UvStorageFactorySPI) {
            PayrollServerSpec payroll = ((UvStorageFactorySPI)factory).payrollServer;
            return Util.equals((Object)this.payrollServer.getHostOrLocalhost(), (Object)payroll.getHostOrLocalhost()) && Util.equals((Object)this.payrollServer.getAccount(), (Object)payroll.getAccount());
        }
        return false;
    }

    @Override
    public boolean containsAnyData() throws IOException, CancelException {
        StorageId[] storageIds;
        for (StorageId storageId : storageIds = this.listStorages()) {
            IStorageSPI<RawRecord> storage = this.createStorage(storageId.getAlias(), RawRecord.class);
            storage.setOuterSpace(storageId.getOuterSpace());
            storage.setInnerSpace(storageId.getInnerSpace());
            String[] ids = storage.getIds();
            if (ids.length <= 0) continue;
            return true;
        }
        return false;
    }
}

