/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.storage.uv;

import asjava.uniclientlibs.UniDynArray;
import asjava.uniclientlibs.UniException;
import asjava.uniclientlibs.UniString;
import asjava.uniclientlibs.UniStringTokenizer;
import asjava.uniclientlibs.UniTokens;
import asjava.uniobjects.UniFile;
import asjava.uniobjects.UniFileException;
import asjava.uniobjects.UniSelectList;
import com.selima.fbi.CancelException;
import com.selima.fbi.storage.uv.IFileTypeProvider;
import com.selima.fbi.storage.uv.StandaloneUvSession;
import com.selima.fbi.storage.uv.TransactionalFileWork;
import com.selima.fbi.storage.uv.TransactionalUvSession;
import com.selima.fbi.storage.uv.UvFilesAccess;
import com.selima.fbi.storage.uv.UvNameEncoder;
import com.selima.fbi.storage.uv.UvSessionInterceptor;
import com.selima.fbi.storage.uv.UvStorageException;
import com.selima.fbi.user.PayrollServerSpec;
import com.selima.framework.util.logging.LogAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;

public class UvFilesAccessImpl
implements UvFilesAccess {
    private StandaloneUvSession standaloneSession;
    private TransactionalUvSession transactionalSession;

    public UvFilesAccessImpl(PayrollServerSpec serverSpec, IFileTypeProvider fileTypeProvider) {
        this.standaloneSession = new StandaloneUvSession(serverSpec);
        this.transactionalSession = new TransactionalUvSession(serverSpec, fileTypeProvider, this.standaloneSession);
    }

    @Override
    public synchronized void begin() throws UvStorageException, CancelException {
        this.transactionalSession.begin();
    }

    @Override
    public synchronized void commit() throws UvStorageException, CancelException {
        this.transactionalSession.commit();
    }

    @Override
    public synchronized void rollback() throws UvStorageException, CancelException {
        this.transactionalSession.rollback();
    }

    @Override
    public synchronized boolean isInTransaction() {
        return this.transactionalSession.isInTransaction();
    }

    @Override
    public synchronized void initialize() throws UvStorageException, CancelException {
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".initialize() begin"));
        this.transactionalSession.executeTransactionalFileWork("VOC", new TransactionalFileWork<Void>(){

            @Override
            public Void run(UniFile voc) throws UniException {
                UniDynArray body = new UniDynArray(voc.read((Object)"CREATE.FILE"));
                body.replace(4, (Object)"V");
                voc.write((Object)"CREATE.FILE", (Object)body);
                return null;
            }
        });
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".initialize() end"));
    }

    @Override
    public synchronized List<String> getIds(String fileName) throws UvStorageException, CancelException {
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".getIds() begin: " + fileName));
        return this.transactionalSession.executeTransactionalFileWork(UvNameEncoder.encodeToOSFileName(fileName), new TransactionalFileWork<List<String>>(){

            @Override
            public List<String> run(UniFile file) throws UvStorageException, UniException {
                UniSelectList selectList = UvFilesAccessImpl.this.transactionalSession.getUniSession().selectList(0);
                selectList.select(file);
                UniDynArray ids = selectList.readList();
                TreeSet<String> result = new TreeSet<String>();
                for (int i = 1; i <= ids.dcount(); ++i) {
                    result.add(ids.extract(i).toString());
                }
                List<String> logicalRecordIds = UvNameEncoder.decodeFromOSFileNames(result);
                LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".getIds() end: " + logicalRecordIds));
                return logicalRecordIds;
            }
        });
    }

    @Override
    public synchronized String read(String fileName, final String id) throws UvStorageException, CancelException {
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".read() begin: " + fileName + ", " + id));
        return this.transactionalSession.executeTransactionalFileWork(UvNameEncoder.encodeToOSFileName(fileName), new TransactionalFileWork<String>(){

            @Override
            public String run(UniFile file) throws UvStorageException, UniException {
                try {
                    String result = file.read((Object)UvNameEncoder.encodeToOSFileName(id)).toString();
                    LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".read() end: " + result));
                    return result;
                }
                catch (UniFileException e) {
                    if (e.getErrorCode() == 30001) {
                        throw new UvStorageException("Record '" + id + "' in the file '" + file.getFileName() + "' does not exist.");
                    }
                    throw e;
                }
            }
        });
    }

    @Override
    public synchronized boolean contains(String fileName, final String id) throws UvStorageException, CancelException {
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".contains() begin: " + fileName + ", " + id));
        return this.transactionalSession.executeTransactionalFileWork(UvNameEncoder.encodeToOSFileName(fileName), new TransactionalFileWork<Boolean>(){

            @Override
            public Boolean run(UniFile file) throws UniException {
                try {
                    file.read((Object)UvNameEncoder.encodeToOSFileName(id));
                    LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".contains() end: true"));
                    return true;
                }
                catch (UniFileException e) {
                    if (e.getErrorCode() == 30001) {
                        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".contains() end: false"));
                        return false;
                    }
                    throw e;
                }
            }
        });
    }

    @Override
    public synchronized void write(String fileName, final String id, final String body) throws UvStorageException, CancelException {
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".write() begin: " + fileName + ", " + id + "," + body));
        this.transactionalSession.executeTransactionalFileWork(UvNameEncoder.encodeToOSFileName(fileName), new TransactionalFileWork<Void>(){

            @Override
            public Void run(UniFile file) throws UniException {
                file.write((Object)UvNameEncoder.encodeToOSFileName(id), (Object)body);
                LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".write() end"));
                return null;
            }
        });
    }

    @Override
    public synchronized void delete(String fileName, final String id) throws UvStorageException, CancelException {
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".delete() begin: " + fileName + ", " + id));
        this.transactionalSession.executeTransactionalFileWork(UvNameEncoder.encodeToOSFileName(fileName), new TransactionalFileWork<Void>(){

            @Override
            public Void run(UniFile file) throws UniException {
                file.deleteRecord((Object)UvNameEncoder.encodeToOSFileName(id));
                LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".delete() end"));
                return null;
            }
        });
    }

    @Override
    public synchronized void deleteFile(String fileName) throws UvStorageException, CancelException {
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".deleteFile() begin: " + fileName));
        String encodedFileName = UvNameEncoder.encodeToOSFileName(fileName);
        if (this.transactionalSession.isFileOpen(encodedFileName)) {
            throw new IllegalStateException("The file " + encodedFileName + " is participating in the current active transaction and therefore can not be deleted.");
        }
        this.standaloneSession.robustDeleteFile(encodedFileName);
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".deleteFile() end"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> query(String query) throws UvStorageException, CancelException {
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".query() begin: " + query));
        List<String> result = null;
        try {
            List<String> list = result = this.standaloneSession.query(query);
            return list;
        }
        finally {
            LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".query() end: " + result));
        }
    }

    @Override
    public void cancel() {
        this.standaloneSession.cancel();
        this.transactionalSession.cancel();
    }

    public synchronized void forceDisconnect() {
        this.standaloneSession.performDisconnect();
        this.transactionalSession.performDisconnect();
    }

    public void setInterceptor(UvSessionInterceptor interceptor) {
        this.standaloneSession.setInterceptor(interceptor);
        this.transactionalSession.setInterceptor(interceptor);
    }

    public void setInterruptTimeput(int interruptTimeput) {
        this.standaloneSession.setInterruptTimeput(interruptTimeput);
        this.transactionalSession.setInterruptTimeput(interruptTimeput);
    }

    void setMaxLockAttemptsCount(int maxLockAttemptsCount) {
        this.transactionalSession.setMaxLockAttemptsCount(maxLockAttemptsCount);
    }

    @Override
    public List<String> readMultivalues(String fileName, final String id) throws UvStorageException, CancelException {
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".readMultivalues() begin: " + fileName + ", " + id));
        return this.transactionalSession.executeTransactionalFileWork(UvNameEncoder.encodeToOSFileName(fileName), new TransactionalFileWork<List<String>>(){

            @Override
            public List<String> run(UniFile file) throws UvStorageException, UniException {
                try {
                    UniString string = file.read((Object)UvNameEncoder.encodeToOSFileName(id));
                    ArrayList<String> result = new ArrayList<String>(string.dcount());
                    UniStringTokenizer tok = new UniStringTokenizer((Object)string, (Object)UniTokens.AT_FM);
                    while (tok.hasMoreTokens()) {
                        result.add(tok.nextToken());
                    }
                    LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".readMutlivalues() end: " + result));
                    return result;
                }
                catch (UniFileException e) {
                    if (e.getErrorCode() == 30001) {
                        throw new UvStorageException("Record '" + id + "' in the file '" + file.getFileName() + "' does not exist.");
                    }
                    throw e;
                }
            }
        });
    }

    @Override
    public void writeMultivalues(String fileName, final String id, final List<String> body) throws UvStorageException, CancelException {
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".writeMultivalues() begin: " + fileName + ", " + id + "," + body));
        this.transactionalSession.executeTransactionalFileWork(UvNameEncoder.encodeToOSFileName(fileName), new TransactionalFileWork<Void>(){

            @Override
            public Void run(UniFile file) throws UniException {
                UniDynArray array = new UniDynArray();
                ListIterator it = body.listIterator();
                while (it.hasNext()) {
                    array.insert(it.nextIndex() + 1, it.next());
                }
                file.write((Object)UvNameEncoder.encodeToOSFileName(id), (Object)array);
                LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".writeMultivalues() end"));
                return null;
            }
        });
    }
}

