/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.storage.uv;

import asjava.uniclientlibs.UniException;
import asjava.uniobjects.UniCommand;
import asjava.uniobjects.UniJava;
import asjava.uniobjects.UniSession;
import asjava.uniobjects.UniSessionException;
import com.selima.fbi.CancelException;
import com.selima.fbi.storage.uv.NullUvSessionInterceptor;
import com.selima.fbi.storage.uv.UvSessionInterceptor;
import com.selima.fbi.storage.uv.UvStorageException;
import com.selima.fbi.user.PayrollServerSpec;
import com.selima.fbi.util.ReflectionUtil;
import com.selima.framework.util.logging.LogAPI;
import java.lang.reflect.Field;
import java.net.Socket;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public abstract class AbstractUvSession {
    private static UniJava uniJava;
    private int delayShutdownTimeout = 4000;
    private TimerTask shutdownTask;
    private Timer shutdownTimer;
    private volatile boolean cancelRequested;
    private int interruptTimeput = 4000;
    private Timer interruptTimer;
    private volatile boolean interrupted;
    private Object interruptSynchronization = new Object();
    private Thread connectingThread;
    private PayrollServerSpec serverSpec;
    private UniSession uniSession;
    private UvSessionInterceptor interceptor;

    public AbstractUvSession(PayrollServerSpec serverSpec) {
        this.serverSpec = serverSpec;
        this.interceptor = new NullUvSessionInterceptor();
    }

    public void cancel() {
        LogAPI.logFine((String)"Canceling Universe execution");
        this.cancelRequested = true;
        this.scheduleInterrupt();
    }

    public boolean cancelRequested() {
        return this.cancelRequested;
    }

    protected UniSession getUniSession() {
        return this.uniSession;
    }

    protected synchronized <T> T execute(UniObjectsWork<T> work) throws UvStorageException, CancelException {
        this.cancelScheduledDisconnect();
        this.cancelRequested = false;
        Throwable error = null;
        int flags = work.getFlags();
        try {
            this.interceptor.beforeWorkRun();
            if ((flags & 2) != 0) {
                this.connectIfNecessary();
            }
            T t = work.run();
            return t;
        }
        catch (UniException e) {
            error = e;
            this.checkInterrupting(e);
            throw new UvStorageException(e);
        }
        catch (UvStorageException e) {
            error = e;
            this.checkInterrupting(e);
            throw e;
        }
        catch (CancelException e) {
            error = e;
            throw e;
        }
        catch (RuntimeException e) {
            error = e;
            this.checkInterrupting(e);
            throw e;
        }
        finally {
            this.cancelRequested = false;
            this.interrupted = false;
            this.cancelSheduledInterrupt();
            if (error == null) {
                if ((flags & 1) != 0) {
                    this.scheduleDisconnect();
                }
            } else if ((flags & 4) != 0) {
                this.performDisconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String executeCommand(String commandStr) throws CancelException, UniException, UvStorageException {
        this.checkCancelRequested();
        LogAPI.logFine((String)("Executing command: " + commandStr));
        UniCommand command = this.uniSession.command();
        command.setCommand(commandStr);
        command.exec();
        StringBuilder response = new StringBuilder();
        do {
            this.checkCancelRequested();
            response.append(command.response());
        } while (command.status() == 2);
        LogAPI.logFine((String)("Command response: " + response));
        this.checkCancelRequested();
        int status = command.status();
        if (status != 0) {
            try {
                command.cancel();
            }
            finally {
                UvStorageException e = new UvStorageException("Universe command >>>" + commandStr + "<<< did not finish successfully.Status: " + command.status() + " Output: " + response);
                LogAPI.logFine((String)("Command response: " + e.getMessage()));
                throw e;
            }
        }
        int returnCode = command.getSystemReturnCode();
        if (returnCode < 0) {
            UvStorageException e = new UvStorageException("Universe command >>>" + commandStr + "<<< did not finish successfully.System return code: " + returnCode + " Output: " + response);
            LogAPI.logFine((String)("Command response: " + e.getMessage()));
            throw e;
        }
        return response.toString();
    }

    protected void checkCancelRequested() throws CancelException {
        if (this.cancelRequested) {
            LogAPI.logFine((String)"Cancel was gentle, no interrupt necessary");
            throw new CancelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectIfNecessary() throws UniException, UvStorageException, CancelException {
        this.checkCancelRequested();
        if (this.uniSession == null) {
            if (uniJava == null) {
                uniJava = new UniJava();
            }
            Object object = this.interruptSynchronization;
            synchronized (object) {
                this.connectingThread = Thread.currentThread();
            }
            try {
                for (int attempt = 10; attempt > 0; --attempt) {
                    try {
                        LogAPI.logFine((String)("Connecting: " + this.serverSpec));
                        if (System.getProperty("clientencoding") == null) {
                            throw new IllegalStateException("UV connection clientencoding undefined!");
                        }
                        UniJava uniJava = AbstractUvSession.uniJava;
                        synchronized (uniJava) {
                            this.uniSession = AbstractUvSession.uniJava.openSession();
                        }
                        this.uniSession.setDefaultLockStrategy(0);
                        this.uniSession.setDefaultBlockingStrategy(2);
                        this.checkCancelRequested();
                        this.interceptor.beforeConnect();
                        if (this.serverSpec.getPort() == null) {
                            this.uniSession.connect((Object)this.serverSpec.getHostOrLocalhost(), (Object)this.serverSpec.getUser(), (Object)this.serverSpec.getPassword(), (Object)this.serverSpec.getAccount());
                        } else {
                            this.uniSession.connect((Object)this.serverSpec.getHostOrLocalhost(), this.serverSpec.getPort().intValue(), (Object)this.serverSpec.getUser(), (Object)this.serverSpec.getPassword(), (Object)this.serverSpec.getAccount());
                        }
                        LogAPI.logFine((String)("Connected: " + this.uniSession));
                        break;
                    }
                    catch (UniSessionException e) {
                        this.checkInterrupting(e);
                        if (this.isRecoverable(e) && attempt > 1) {
                            try {
                                Thread.sleep(2000L);
                                continue;
                            }
                            catch (InterruptedException interruption) {
                                this.checkInterrupting(e);
                                break;
                            }
                        }
                        throw e;
                    }
                }
            }
            finally {
                Object object2 = this.interruptSynchronization;
                synchronized (object2) {
                    Thread.interrupted();
                    this.connectingThread = null;
                }
            }
            this.executeCommand("DATE.FORMAT");
            this.executeCommand("LONGNAMES ON");
        }
    }

    private boolean isRecoverable(UniSessionException e) {
        switch (e.getErrorCode()) {
            case 14005: 
            case 14028: 
            case 14551: 
            case 39131: 
            case 39134: 
            case 39202: 
            case 39207: 
            case 45001: 
            case 81001: 
            case 81002: 
            case 81007: 
            case 81009: 
            case 81015: {
                return true;
            }
        }
        return false;
    }

    private void checkInterrupting(Throwable cause) throws CancelException {
        if (this.interrupted) {
            LogAPI.logFine((String)("Forced close caused " + cause));
            throw new CancelException(cause);
        }
    }

    private void scheduleDisconnect() {
        if (this.shutdownTask != null) {
            throw new IllegalStateException();
        }
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".scheduleDisconnect() scheduling a new timer"));
        if (this.shutdownTimer == null) {
            this.shutdownTimer = new Timer("Universe-Peaceful-Close", true);
        }
        this.shutdownTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".scheduleDisconnect() the timer fired"));
                AbstractUvSession abstractUvSession = AbstractUvSession.this;
                synchronized (abstractUvSession) {
                    if (AbstractUvSession.this.shutdownTask == this) {
                        AbstractUvSession.this.performDisconnect();
                    }
                }
            }
        };
        this.shutdownTimer.schedule(this.shutdownTask, this.delayShutdownTimeout);
    }

    private void cancelScheduledDisconnect() {
        if (this.shutdownTask != null) {
            LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".cancelScheduledDisconnect()"));
            this.shutdownTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performDisconnect() {
        LogAPI.logFiner((String)(this.getClass().getSimpleName() + ".forceDisconnect()"));
        if (this.uniSession != null) {
            LogAPI.logFine((String)("Disconnecting: " + this.uniSession));
            try {
                this.uniSession.disconnect();
            }
            catch (UniException e) {
                LogAPI.logWarning((Throwable)e);
            }
            UniJava uniJava = AbstractUvSession.uniJava;
            synchronized (uniJava) {
                try {
                    Field field = UniJava.class.getDeclaredField("uniSessionsVector");
                    field.setAccessible(true);
                    Vector uniSessionsVector = (Vector)field.get(null);
                    uniSessionsVector.remove(this.uniSession);
                }
                catch (Exception e) {
                    LogAPI.logSevere((Throwable)e);
                }
            }
            this.uniSession = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelSheduledInterrupt() {
        Object object = this.interruptSynchronization;
        synchronized (object) {
            if (this.interruptTimer != null) {
                this.interruptTimer.cancel();
                this.interruptTimer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleInterrupt() {
        Object object = this.interruptSynchronization;
        synchronized (object) {
            if (this.interruptTimer != null) {
                return;
            }
            this.interruptTimer = new Timer("Universe-Force-Close", true);
            TimerTask interruptTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = AbstractUvSession.this.interruptSynchronization;
                    synchronized (object) {
                        if (AbstractUvSession.this.interruptTimer != null) {
                            AbstractUvSession.this.performInterrupt();
                        }
                    }
                }
            };
            LogAPI.logFine((String)("Scheduling interrupt no. [" + System.identityHashCode(interruptTask) + "] in " + this.interruptTimeput + " ms"));
            this.interruptTimer.schedule(interruptTask, this.interruptTimeput);
        }
    }

    private void performInterrupt() {
        block8: {
            this.interrupted = true;
            try {
                if (this.connectingThread != null) {
                    LogAPI.logFine((String)("Interrupt no. [" + System.identityHashCode(this) + "]"));
                    this.connectingThread.interrupt();
                    break block8;
                }
                if (this.uniSession == null) break block8;
                try {
                    LogAPI.logFine((String)("Forced close no. [" + System.identityHashCode(this) + "]"));
                    Socket socket = ReflectionUtil.getFieldValue(this.uniSession, Socket.class, "connection", "socket", "socket");
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        LogAPI.logSevere((Throwable)e);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            finally {
                this.uniSession = null;
                this.interceptor.afterInterrupt();
            }
        }
    }

    public void setInterceptor(UvSessionInterceptor interceptor) {
        if (interceptor == null) {
            interceptor = new NullUvSessionInterceptor();
        }
        this.interceptor = interceptor;
    }

    public void setInterruptTimeput(int interruptTimeput) {
        this.interruptTimeput = interruptTimeput;
    }

    protected static interface UniObjectsWork<T> {
        public static final int SAFE_TO_DISCONNECT = 1;
        public static final int ALLOWED_TO_CONNECT = 2;
        public static final int DISCONNECT_ON_ERROR = 4;

        public int getFlags();

        public T run() throws UniException, UvStorageException, CancelException;
    }
}

