/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.storage.transfer;

import com.selima.fbi.CancelException;
import com.selima.fbi.storage.IExtendedStorageFactory;
import com.selima.fbi.storage.IStorage;
import com.selima.fbi.storage.StorageId;
import com.selima.fbi.storage.transfer.RawRecord;
import java.io.IOException;

public class StorageTransfer {
    private IExtendedStorageFactory source;
    private IExtendedStorageFactory target;

    public StorageTransfer(IExtendedStorageFactory source, IExtendedStorageFactory target) {
        this.source = source;
        this.target = target;
    }

    public void run() throws IOException, CancelException {
        this.deleteAllStoragesInTarget();
        this.copyContentFromSourceToTarget();
    }

    private void deleteAllStoragesInTarget() throws IOException, CancelException {
        StorageId[] storageIds;
        for (StorageId storageId : storageIds = this.target.listStorages()) {
            this.target.deleteStorage(storageId);
        }
    }

    private void copyContentFromSourceToTarget() throws IOException, CancelException {
        StorageId[] storageIds;
        for (StorageId storageId : storageIds = this.source.listStorages()) {
            String[] recordIds;
            this.source.setOuterSpace(storageId.getOuterSpace());
            IStorage<RawRecord> sourceStorage = this.source.getStorage(storageId.getAlias(), storageId.getInnerSpace(), RawRecord.class);
            sourceStorage.setInnerSpace(storageId.getInnerSpace());
            this.target.setOuterSpace(storageId.getOuterSpace());
            IStorage<RawRecord> targetStorage = this.target.getStorage(storageId.getAlias(), storageId.getInnerSpace(), RawRecord.class);
            targetStorage.setInnerSpace(storageId.getInnerSpace());
            for (String recordId : recordIds = sourceStorage.getIds()) {
                RawRecord record = sourceStorage.load(recordId);
                record.setStoreId(recordId);
                record.setStoreSpace(storageId.getInnerSpace());
                targetStorage.store(record);
            }
        }
    }
}

