/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.storage.memory;

import com.selima.fbi.CancelException;
import com.selima.fbi.storage.IStorageProvider;
import com.selima.fbi.storage.memory.AbstractInMemoryData;
import com.selima.fbi.storage.memory.CompositeId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class InMemoryStorageProvider
extends AbstractInMemoryData<byte[]>
implements IStorageProvider {
    @Override
    public InputStream getInputStream(String id) throws IOException {
        byte[] data = (byte[])this.get(this.createId(id));
        return new ByteArrayInputStream(data);
    }

    @Override
    public OutputStream getOutputStream(String id) throws IOException {
        return new InMemoryStorageOutputStream(this.createId(id));
    }

    public void init(Properties parameters) {
    }

    @Override
    public boolean isInTransaction() {
        return false;
    }

    @Override
    public void begin() throws IOException, CancelException {
    }

    @Override
    public void commit() throws IOException, CancelException {
    }

    @Override
    public void rollback() throws IOException, CancelException {
    }

    class InMemoryStorageOutputStream
    extends ByteArrayOutputStream {
        CompositeId id;

        public InMemoryStorageOutputStream(CompositeId id) {
            this.id = id;
            this.updateMap();
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.updateMap();
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.updateMap();
        }

        private void updateMap() {
            InMemoryStorageProvider.this.put(this.id, this.toByteArray());
        }
    }
}

