/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.storage.memory;

import com.selima.fbi.storage.IStorable;
import com.selima.fbi.storage.IStorage;
import com.selima.fbi.storage.IStorageFactory;
import com.selima.fbi.storage.memory.InMemoryStorage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class InMemoryStorageFactory
implements IStorageFactory {
    private Map<String, InMemoryStorage<?>> map = new HashMap();

    @Override
    public String getName() {
        return "Memory";
    }

    @Override
    public <T extends IStorable> IStorage<T> getStorage(String alias, Class<T> storedType) throws IOException {
        InMemoryStorage<Object> storage = this.map.get(alias);
        if (storage == null) {
            storage = new InMemoryStorage<T>(storedType);
            this.map.put(alias, storage);
        }
        return storage;
    }

    @Override
    public <T extends IStorable> IStorage<T> getStorage(String alias, String innerSpace, Class<T> storedType) throws IOException {
        return this.getStorage(alias + "/" + innerSpace, storedType);
    }

    @Override
    public void setOuterSpace(String outerSpace) {
    }

    @Override
    public void begin() throws IOException {
    }

    @Override
    public void commit() throws IOException {
    }

    @Override
    public void rollback() throws IOException {
    }

    @Override
    public boolean isInTransaction() {
        return false;
    }

    @Override
    public void cancel() {
    }
}

