/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.storage.file;

import com.selima.fbi.CancelException;
import com.selima.fbi.storage.IStorageProvider;
import com.selima.fbi.util.IOUtil;
import com.selima.framework.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EmptyStackException;
import java.util.LinkedList;
import java.util.Stack;

public class FileSystemStorageProvider
implements IStorageProvider {
    private File dataDir;
    private String contentType;
    private String innerSpace;
    private String outerSpace;
    private String alias;

    FileSystemStorageProvider(File parentDir, String alias, String contentType) {
        this.alias = alias;
        this.contentType = contentType;
        this.dataDir = new File(parentDir, alias);
    }

    FileSystemStorageProvider(File parentDir, File userDir, String contentType) throws IOException {
        Stack<String> stack = new Stack<String>();
        try {
            File dir = userDir;
            while (!parentDir.equals(dir)) {
                stack.push(dir.getName());
                dir = dir.getParentFile();
            }
            this.alias = (String)stack.pop();
            this.contentType = contentType;
            this.dataDir = new File(parentDir, this.alias);
            this.outerSpace = (String)stack.pop();
            if (!stack.isEmpty()) {
                this.innerSpace = (String)stack.pop();
            }
        }
        catch (EmptyStackException e) {
            throw new IOException("Invalid storage location: " + userDir.getPath());
        }
    }

    public File getUserDir() {
        if (this.outerSpace == null) {
            throw new IllegalStateException("with outerSpace of null there would be no unique mapping between the directory structure and inner / outer space");
        }
        File dir = new File(this.dataDir, this.outerSpace);
        if (!Util.isEmpty((Object)this.innerSpace)) {
            dir = new File(dir, this.innerSpace);
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    @Override
    public String[] getIds() {
        final LinkedList idList = new LinkedList();
        this.getUserDir().list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String postfix = FileSystemStorageProvider.this.getFilePostfix();
                if (name.endsWith(postfix)) {
                    String id = IOUtil.fileToId(name);
                    id = id.substring(0, id.length() - postfix.length());
                    idList.add(id);
                }
                return false;
            }
        });
        return idList.toArray(new String[idList.size()]);
    }

    private String getFilePostfix() {
        return "." + this.contentType;
    }

    @Override
    public void delete(String id) throws IOException {
        File file = this.getFile(id);
        if (!file.delete()) {
            throw new IOException("Can't delete file: " + id + this.getFilePostfix());
        }
    }

    protected File getFile(String id) {
        return new File(this.getUserDir(), IOUtil.idToFile(id + this.getFilePostfix()));
    }

    String getAlias() {
        return this.alias;
    }

    String getInnerSpace() {
        if (this.innerSpace == null) {
            return null;
        }
        return IOUtil.fileToId(this.innerSpace);
    }

    @Override
    public void setInnerSpace(String space) {
        if (space != null) {
            space = IOUtil.idToFile(space);
        }
        this.innerSpace = space;
    }

    String getOuterSpace() {
        return this.outerSpace;
    }

    @Override
    public void setOuterSpace(String space) {
        this.outerSpace = space;
    }

    @Override
    public boolean contains(String id) throws IOException {
        return this.getFile(id).exists();
    }

    @Override
    public InputStream getInputStream(String id) throws IOException {
        return new FileInputStream(this.getFile(id));
    }

    @Override
    public OutputStream getOutputStream(String id) throws IOException {
        return new FileOutputStream(this.getFile(id));
    }

    @Override
    public boolean isInTransaction() {
        return false;
    }

    @Override
    public void begin() throws IOException, CancelException {
    }

    @Override
    public void commit() throws IOException, CancelException {
    }

    @Override
    public void rollback() throws IOException, CancelException {
    }
}

