/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.storage.file;

import com.selima.fbi.CancelException;
import com.selima.fbi.storage.IStorageProvider;
import com.selima.fbi.storage.WrappingStorageProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class DigestStorageProvider
extends WrappingStorageProvider {
    IStorageProvider digestProvider;

    DigestStorageProvider(IStorageProvider dataProvider) {
        super(dataProvider);
        this.digestProvider = new DigestProvider(dataProvider);
    }

    @Override
    public String[] getIds() throws IOException, CancelException {
        LinkedList<String> result = new LinkedList<String>(Arrays.asList(super.getIds()));
        result.removeAll(Arrays.asList(this.digestProvider.getIds()));
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void delete(String id) throws IOException, CancelException {
        this.digestProvider.delete(id);
        super.delete(id);
    }

    @Override
    public void setInnerSpace(String user) {
        this.digestProvider.setInnerSpace(user);
        super.setInnerSpace(user);
    }

    @Override
    public InputStream getInputStream(String id) throws IOException, CancelException {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            return new DigestingInputStream(super.getInputStream(id), this.digestProvider.getInputStream(id), md5);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public OutputStream getOutputStream(String id) throws IOException, CancelException {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            return new DigestingOutputStream(super.getOutputStream(id), this.digestProvider.getOutputStream(id), md5);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    static class DigestingOutputStream
    extends OutputStream {
        OutputStream wrappedStream;
        OutputStream digestStream;
        MessageDigest messageDigest;

        DigestingOutputStream(OutputStream outputStream, OutputStream digestStream, MessageDigest messageDigest) {
            this.digestStream = digestStream;
            this.wrappedStream = outputStream;
            this.messageDigest = messageDigest;
        }

        @Override
        public void write(int b) throws IOException {
            this.messageDigest.update((byte)b);
            this.wrappedStream.write(b);
        }

        @Override
        public void close() throws IOException {
            try {
                this.wrappedStream.close();
                this.writeDigest();
            }
            finally {
                this.digestStream.close();
            }
        }

        private void writeDigest() throws IOException {
            this.digestStream.write(this.messageDigest.digest());
        }

        @Override
        public void flush() throws IOException {
            this.wrappedStream.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.messageDigest.update(b);
            this.wrappedStream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.messageDigest.update(b, off, len);
            this.wrappedStream.write(b, off, len);
        }
    }

    static class DigestProvider
    extends WrappingStorageProvider {
        public DigestProvider(IStorageProvider storageProvider) {
            super(storageProvider);
        }

        @Override
        public String[] getIds() throws IOException, CancelException {
            LinkedList<String> ids = new LinkedList<String>(Arrays.asList(super.getIds()));
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                if (((String)it.next()).endsWith(".digest")) continue;
                it.remove();
            }
            return ids.toArray(new String[ids.size()]);
        }

        @Override
        public boolean contains(String id) throws IOException, CancelException {
            assert (!id.endsWith(".digest"));
            return super.contains(id + ".digest");
        }

        @Override
        public void delete(String id) throws IOException, CancelException {
            assert (!id.endsWith(".digest"));
            super.delete(id + ".digest");
        }

        @Override
        public InputStream getInputStream(String id) throws IOException, CancelException {
            assert (!id.endsWith(".digest"));
            return super.getInputStream(id + ".digest");
        }

        @Override
        public OutputStream getOutputStream(String id) throws IOException, CancelException {
            assert (!id.endsWith(".digest"));
            return super.getOutputStream(id + ".digest");
        }
    }

    static class DigestingInputStream
    extends InputStream {
        InputStream wrappedStream;
        InputStream digestStream;
        MessageDigest messageDigest;

        DigestingInputStream(InputStream inputStream, InputStream digestStream, MessageDigest messageDigest) {
            this.digestStream = digestStream;
            this.wrappedStream = inputStream;
            this.messageDigest = messageDigest;
        }

        @Override
        public int read() throws IOException {
            int result = this.wrappedStream.read();
            if (result >= 0) {
                this.messageDigest.update((byte)result);
            } else {
                this.checkDigest();
            }
            return result;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int result = this.wrappedStream.read(b);
            if (result > 0) {
                this.messageDigest.update(b, 0, result);
            } else {
                this.checkDigest();
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.wrappedStream.read(b, off, len);
            if (result > 0) {
                this.messageDigest.update(b, off, result);
            } else {
                this.checkDigest();
            }
            return result;
        }

        @Override
        public long skip(long n) throws IOException {
            for (long i = 0L; i < n; ++i) {
                int b = this.wrappedStream.read();
                if (b == -1) {
                    this.checkDigest();
                    return i;
                }
                this.messageDigest.update((byte)b);
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            try {
                this.wrappedStream.close();
            }
            finally {
                this.digestStream.close();
            }
        }

        private void checkDigest() throws IOException {
            byte[] computedDigest;
            byte[] storedDigest = this.loadDigest();
            if (!MessageDigest.isEqual(storedDigest, computedDigest = this.messageDigest.digest())) {
                throw new IOException("Security Failure: Item has been tampered");
            }
        }

        private byte[] loadDigest() throws IOException {
            ByteBuffer bytes = ByteBuffer.allocate(this.messageDigest.getDigestLength());
            int b = this.digestStream.read();
            while (b != -1) {
                bytes.put((byte)b);
                b = this.digestStream.read();
            }
            assert (bytes.remaining() == 0);
            return bytes.array();
        }
    }
}

