/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.storage;

import com.selima.fbi.CancelException;
import com.selima.fbi.storage.TransactionalResource;
import com.selima.framework.util.logging.LogAPI;
import java.io.IOException;

public class Transaction {
    final TransactionalResource resource;
    boolean success;
    boolean managedLocally;

    public Transaction(TransactionalResource factory) {
        this.resource = factory;
    }

    public void run(InteractionV0 interaction) throws IOException, CancelException {
        this.joinTransaction();
        try {
            interaction.run();
            this.success = true;
        }
        finally {
            this.resolveTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(InteractionR0<T> interaction) throws IOException, CancelException {
        this.joinTransaction();
        try {
            T result = interaction.run();
            this.success = true;
            T t = result;
            return t;
        }
        finally {
            this.resolveTransaction();
        }
    }

    public <ExceptionType extends Throwable> void run(InteractionV1<ExceptionType> interaction) throws ExceptionType, IOException, CancelException {
        this.joinTransaction();
        try {
            interaction.run();
            this.success = true;
        }
        finally {
            this.resolveTransaction();
        }
    }

    public <ExceptionType1 extends Throwable, ExceptionType2 extends Throwable> void run(InteractionV2<ExceptionType1, ExceptionType2> interaction) throws ExceptionType1, ExceptionType2, IOException, CancelException {
        this.joinTransaction();
        try {
            interaction.run();
            this.success = true;
        }
        finally {
            this.resolveTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReturnType, ExceptionType extends Throwable> ReturnType run(InteractionR1<ReturnType, ExceptionType> interaction) throws ExceptionType, IOException, CancelException {
        this.joinTransaction();
        try {
            ReturnType result = interaction.run();
            this.success = true;
            ReturnType ReturnType = result;
            return ReturnType;
        }
        finally {
            this.resolveTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReturnType, ExceptionType1 extends Throwable, ExceptionType2 extends Throwable> ReturnType run(InteractionR2<ReturnType, ExceptionType1, ExceptionType2> interaction) throws ExceptionType1, ExceptionType2, IOException, CancelException {
        this.joinTransaction();
        try {
            ReturnType result = interaction.run();
            this.success = true;
            ReturnType ReturnType = result;
            return ReturnType;
        }
        finally {
            this.resolveTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReturnType, ExceptionType1 extends Throwable, ExceptionType2 extends Throwable, ExceptionType3 extends Throwable> ReturnType run(InteractionR3<ReturnType, ExceptionType1, ExceptionType2, ExceptionType3> interaction) throws ExceptionType1, ExceptionType2, ExceptionType3, IOException, CancelException {
        this.joinTransaction();
        try {
            ReturnType result = interaction.run();
            this.success = true;
            ReturnType ReturnType = result;
            return ReturnType;
        }
        finally {
            this.resolveTransaction();
        }
    }

    private void joinTransaction() throws IOException, CancelException {
        if (!this.resource.isInTransaction()) {
            this.resource.begin();
            this.managedLocally = this.resource.isInTransaction();
        } else {
            this.managedLocally = false;
        }
        this.success = false;
    }

    private void resolveTransaction() throws IOException, CancelException {
        if (!this.managedLocally) {
            return;
        }
        if (this.success) {
            this.resource.commit();
        } else {
            try {
                this.resource.rollback();
            }
            catch (IOException e) {
                LogAPI.logSevere((Throwable)e);
            }
        }
    }

    public static interface InteractionV3<ExceptionType1 extends Throwable, ExceptionType2 extends Throwable, ExceptionType3 extends Throwable> {
        public void run() throws ExceptionType1, ExceptionType2, ExceptionType3, IOException, CancelException;
    }

    public static interface InteractionR3<ReturnType, ExceptionType1 extends Throwable, ExceptionType2 extends Throwable, ExceptionType3 extends Throwable> {
        public ReturnType run() throws ExceptionType1, ExceptionType2, ExceptionType3, IOException, CancelException;
    }

    public static interface InteractionV2<ExceptionType1 extends Throwable, ExceptionType2 extends Throwable> {
        public void run() throws ExceptionType1, ExceptionType2, IOException, CancelException;
    }

    public static interface InteractionR2<ReturnType, ExceptionType1 extends Throwable, ExceptionType2 extends Throwable> {
        public ReturnType run() throws ExceptionType1, ExceptionType2, IOException, CancelException;
    }

    public static interface InteractionV1<ExceptionType extends Throwable> {
        public void run() throws ExceptionType, IOException, CancelException;
    }

    public static interface InteractionR1<ReturnType, ExceptionType extends Throwable> {
        public ReturnType run() throws ExceptionType, IOException, CancelException;
    }

    public static interface InteractionR0<ReturnType> {
        public ReturnType run() throws IOException, CancelException;
    }

    public static interface InteractionV0 {
        public void run() throws IOException, CancelException;
    }
}

