/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.soap.dps.live;

import com.selima.fbi.soap.dps.live.Dps;
import com.selima.fbi.soap.dps.live.DpsSoap;
import com.selima.fbi.soap.dps.live.DpsSoapStub;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class DpsLocator
extends Service
implements Dps {
    private String dpsSoap_address = "https://dps.ws.hmrc.gov.uk/dps/service";
    private String dpsSoapWSDDServiceName = "dpsSoap";
    private HashSet ports = null;

    public DpsLocator() {
    }

    public DpsLocator(EngineConfiguration config) {
        super(config);
    }

    public DpsLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    @Override
    public String getdpsSoapAddress() {
        return this.dpsSoap_address;
    }

    public String getdpsSoapWSDDServiceName() {
        return this.dpsSoapWSDDServiceName;
    }

    public void setdpsSoapWSDDServiceName(String name) {
        this.dpsSoapWSDDServiceName = name;
    }

    @Override
    public DpsSoap getdpsSoap() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.dpsSoap_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getdpsSoap(endpoint);
    }

    @Override
    public DpsSoap getdpsSoap(URL portAddress) throws ServiceException {
        try {
            DpsSoapStub _stub = new DpsSoapStub(portAddress, this);
            _stub.setPortName(this.getdpsSoapWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setdpsSoapEndpointAddress(String address) {
        this.dpsSoap_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (DpsSoap.class.isAssignableFrom(serviceEndpointInterface)) {
                DpsSoapStub _stub = new DpsSoapStub(new URL(this.dpsSoap_address), this);
                _stub.setPortName(this.getdpsSoapWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("dpsSoap".equals(inputPortName)) {
            return this.getdpsSoap();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("https://tpvs.hmrc.gov.uk/dps", "dps");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("https://tpvs.hmrc.gov.uk/dps", "dpsSoap"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"dpsSoap".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setdpsSoapEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

