/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.soap;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class AxisStubWithLog4J {
    public static <T> T wrapStub(T stub, Class<T> type, File logDir) {
        return type.cast(Proxy.newProxyInstance(AxisStubWithLog4J.class.getClassLoader(), new Class[]{type}, (InvocationHandler)new Log4JStubHandler(stub, logDir)));
    }

    static class Log4JStubHandler
    implements InvocationHandler {
        String logFile;
        Object target;

        Log4JStubHandler(Object target, File logDir) {
            this.logFile = new File(logDir, "soaplog.txt").getPath();
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            FileAppender appender;
            Logger logger = Logger.getLogger((String)"org.apache.axis.transport.http.HTTPSender");
            Level originalLevel = logger.getLevel();
            if (originalLevel == null || originalLevel.isGreaterOrEqual((Priority)Level.DEBUG)) {
                logger.setLevel(Level.DEBUG);
            }
            if ((appender = (FileAppender)logger.getAppender("File")) == null) {
                appender = new FileAppender();
                appender.setName("File");
                appender.setFile(this.logFile);
                appender.setAppend(true);
                appender.setLayout((Layout)new PatternLayout("%n%d{dd MMM yyyy HH:mm:ss,SSS}%n%m%n"));
                logger.addAppender((Appender)appender);
                appender.activateOptions();
            } else if (appender.getFile() == null || !appender.getFile().equals(this.logFile)) {
                appender.setFile(this.logFile);
                appender.activateOptions();
            }
            try {
                Object object = method.invoke(this.target, args);
                return object;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                logger.setLevel(originalLevel);
            }
        }
    }
}

