/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.service;

import com.selima.fbi.CancelException;
import com.selima.fbi.hmrcMark.HMRCMark;
import com.selima.fbi.plugin.PluginType;
import com.selima.fbi.service.AbstractMailService;
import com.selima.fbi.service.Axis2DPSErrorTranslator;
import com.selima.fbi.service.AxisSAMLTokenProvider;
import com.selima.fbi.service.AxisSocketClosingClient;
import com.selima.fbi.service.FailedConnectDpsAuthenticationClient;
import com.selima.fbi.service.FailedConnectDpsClient;
import com.selima.fbi.service.IDpsAuthenticationClient;
import com.selima.fbi.service.IDpsClient;
import com.selima.fbi.service.MailServiceException;
import com.selima.fbi.soap.AxisServiceWithHTTPCustomization;
import com.selima.fbi.soap.AxisServiceWithSAMLToken;
import com.selima.fbi.soap.AxisServiceWithUserNameToken;
import com.selima.fbi.soap.AxisStubWithLog4J;
import com.selima.fbi.soap.ICredentialsOwner;
import com.selima.fbi.soap.ISAMLTokenOwner;
import com.selima.fbi.soap.dps.tpvs.DPSdata;
import com.selima.fbi.soap.dps.tpvs.Dps;
import com.selima.fbi.soap.dps.tpvs.DpsLocator;
import com.selima.fbi.soap.dps.tpvs.DpsSoap;
import com.selima.fbi.soap.dps.tpvs.Dpsauthentication;
import com.selima.fbi.soap.dps.tpvs.DpsauthenticationLocator;
import com.selima.fbi.soap.dps.tpvs.DpsauthenticationSoap;
import com.selima.fbi.submission.sender.IGovTalkMessageSender;
import com.selima.fbi.submission.sender.TPVSGovTalkMessageSender;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.w3c.dom.Element;

public class TPVSMailService
extends AbstractMailService {
    @Override
    public void init(Map<String, String> parameters) throws MailServiceException {
        super.init(parameters);
        HMRCMark.setTrustedKeyStore("sarvegacert.jks", "password");
    }

    @Override
    protected IGovTalkMessageSender createSender() {
        if (this.submissionUrl != null) {
            return new TPVSGovTalkMessageSender(this.submissionUrl);
        }
        return new TPVSGovTalkMessageSender();
    }

    @Override
    public IDpsClient createDpsClient(ISAMLTokenOwner samlOwner) throws MailServiceException {
        DpsSoap rawDpsSoap;
        DpsSoap wssDpsSoap;
        Dps wssDps = AxisServiceWithSAMLToken.createService(DpsLocator.class, Dps.class);
        Dps rawDps = AxisServiceWithHTTPCustomization.createService(DpsLocator.class, Dps.class);
        try {
            if (this.dpsUrl != null) {
                wssDpsSoap = wssDps.getdpsSoap(new URL(this.dpsUrl));
                rawDpsSoap = rawDps.getdpsSoap(new URL(this.dpsUrl));
            } else {
                wssDpsSoap = wssDps.getdpsSoap();
                rawDpsSoap = rawDps.getdpsSoap();
            }
        }
        catch (ServiceException e) {
            throw new MailServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new MailServiceException(e);
        }
        DpsSoap dpsSoap = AxisSAMLTokenProvider.wrapStub(wssDpsSoap, rawDpsSoap, DpsSoap.class, samlOwner);
        dpsSoap = Axis2DPSErrorTranslator.wrapStub(dpsSoap, DpsSoap.class);
        if (this.logEnabled) {
            dpsSoap = AxisStubWithLog4J.wrapStub(dpsSoap, DpsSoap.class, this.loggerDir);
        }
        return new FailedConnectDpsClient(new DpsClientImpl(dpsSoap));
    }

    @Override
    public IDpsAuthenticationClient createDpsAuthenticationClient(ICredentialsOwner credentialsOwner) throws MailServiceException {
        DpsauthenticationSoap dpsauthenticationSoap;
        Dpsauthentication service = AxisServiceWithUserNameToken.createService(DpsauthenticationLocator.class, Dpsauthentication.class, credentialsOwner);
        try {
            dpsauthenticationSoap = this.authenticationUrl != null ? service.getdpsauthenticationSoap(new URL(this.authenticationUrl)) : service.getdpsauthenticationSoap();
        }
        catch (ServiceException e) {
            throw new MailServiceException(e);
        }
        catch (MalformedURLException e) {
            throw new MailServiceException(e);
        }
        dpsauthenticationSoap = Axis2DPSErrorTranslator.wrapStub(dpsauthenticationSoap, DpsauthenticationSoap.class);
        if (this.logEnabled) {
            dpsauthenticationSoap = AxisStubWithLog4J.wrapStub(dpsauthenticationSoap, DpsauthenticationSoap.class, this.loggerDir);
        }
        return new FailedConnectDpsAuthenticationClient(new DpsAuthenticationImpl(dpsauthenticationSoap));
    }

    @Override
    public PluginType getDefaultPluginType() {
        return PluginType.test;
    }

    static class DpsAuthenticationImpl
    extends AxisSocketClosingClient
    implements IDpsAuthenticationClient {
        DpsauthenticationSoap dpsauthenticationSoap;

        public DpsAuthenticationImpl(DpsauthenticationSoap dpsauthenticationSoap) {
            this.dpsauthenticationSoap = dpsauthenticationSoap;
        }

        @Override
        public String DPSrequestToken(int version, String vendorID) throws RemoteException, CancelException {
            try {
                return this.dpsauthenticationSoap.DPSrequestToken(version, vendorID);
            }
            catch (AxisFault e) {
                this.checkCancel(e);
                throw e;
            }
        }
    }

    static class DpsClientImpl
    extends AxisSocketClosingClient
    implements IDpsClient {
        DpsSoap dpsSoap;

        DpsClientImpl(DpsSoap dpsSoap) {
            this.dpsSoap = dpsSoap;
        }

        @Override
        public long DPSretrieve(int version, String vendorID, String service, String entityType, String entity, String dataType, long got, int nItems, List<Element> data) throws CancelException, RemoteException {
            try {
                DPSdata dpsData = this.dpsSoap.DPSretrieve(version, vendorID, service, entityType, entity, dataType, got, nItems);
                if (dpsData.get_any() != null) {
                    data.addAll(Arrays.asList(dpsData.get_any()));
                }
                return Math.max(got, dpsData.getDPSheader().getHighWaterMark().longValue());
            }
            catch (AxisFault e) {
                this.checkCancel(e);
                throw e;
            }
        }

        @Override
        public int DPSquery(int version, String vendorID, String service, String entityType, String entity, String dataType, long got) throws CancelException, RemoteException {
            try {
                return (int)this.dpsSoap.DPSquery(version, vendorID, service, entityType, entity, dataType, got);
            }
            catch (AxisFault e) {
                this.checkCancel(e);
                throw e;
            }
        }

        @Override
        public long DPSdate2Index(int version, String vendorID, String service, String entityType, String entity, String dataType, Calendar date) throws RemoteException, CancelException {
            try {
                return this.dpsSoap.DPSdate2Index(version, vendorID, service, entityType, entity, dataType, date);
            }
            catch (AxisFault e) {
                this.checkCancel(e);
                throw e;
            }
        }
    }
}

