/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.service;

import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.service.FakeMailService;
import com.selima.fbi.service.IMailService;
import com.selima.fbi.service.LiveMailService;
import com.selima.fbi.service.MailServiceException;
import com.selima.fbi.service.TPVSMailService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MailServiceFactory {
    public static String[] getAliases(Map<String, String> props) {
        String services = props.get("service.show");
        String[] split = services.split(",");
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(split));
        block0: for (String service : split) {
            for (Locator locator : Locator.values()) {
                if (locator.name().equals(service)) continue block0;
            }
            list.remove(service);
        }
        return list.toArray(new String[list.size()]);
    }

    public static final IMailService createService(String alias) throws MailServiceException {
        return MailServiceFactory.createService(alias, MailServiceConfig.getInitParamaters());
    }

    static IMailService createService(String alias, Map<String, String> props) throws MailServiceException {
        try {
            Class<? extends IMailService> type = Locator.valueOf((String)alias).type;
            IMailService service = type.newInstance();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("alias", alias);
            Pattern pattern = Pattern.compile("service\\.([^\\.]+)\\.(.+)");
            for (Map.Entry<String, String> entry : props.entrySet()) {
                Matcher matcher = pattern.matcher(entry.getKey());
                if (matcher.matches()) {
                    if (!alias.equals(matcher.group(1))) continue;
                    params.put(matcher.group(2), entry.getValue());
                    continue;
                }
                params.put(entry.getKey(), entry.getValue());
            }
            service.init(params);
            return service;
        }
        catch (InstantiationException e) {
            throw new MailServiceException(e);
        }
        catch (IllegalAccessException e) {
            throw new MailServiceException(e);
        }
    }

    static enum Locator {
        live(LiveMailService.class),
        tpvs(TPVSMailService.class),
        fake(FakeMailService.class);

        Class<? extends IMailService> type;

        private Locator(Class<? extends IMailService> type) {
            this.type = type;
        }
    }
}

