/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.service;

import com.selima.fbi.CancelException;
import com.selima.fbi.service.DPSErrorEnum;
import com.selima.fbi.service.DPSException;
import com.selima.fbi.service.FakeAAModelImpl;
import com.selima.fbi.service.FakeDatabaseImpl;
import com.selima.fbi.service.IFakeAAModel;
import com.selima.fbi.service.IFakeDatabase;
import com.selima.fbi.service.IFakeServiceContext;
import com.selima.framework.util.logging.LogAPI;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FakeServiceContextImpl
implements IFakeServiceContext {
    FakeDatabaseImpl fakeDatabaseImpl = new FakeDatabaseImpl();
    MethodCounter methodCounter = new MethodCounter();
    FakeAAModelImpl aaModel = new FakeAAModelImpl();

    @Override
    public IFakeDatabase getFakeDatabase() {
        return this.fakeDatabaseImpl;
    }

    @Override
    public IFakeAAModel getAAModel() {
        return this.aaModel;
    }

    @Override
    public int getTokenDuration() {
        return 360000;
    }

    @Override
    public int getCallTimeout() {
        return 50;
    }

    @Override
    public void checkArtificialFailure(String method) throws DPSException, CancelException, ConnectException, RemoteException {
        int count = this.methodCounter.get(method);
        String failureSpecification = System.getProperty(method);
        if (failureSpecification != null) {
            Pattern pattern = Pattern.compile("(\\w+):(\\d+(,\\d++)*)(:(repeat))?");
            Matcher matcher = pattern.matcher(failureSpecification);
            if (!matcher.matches()) {
                LogAPI.logWarning((String)("Malformed failure specification: " + failureSpecification));
                return;
            }
            TreeSet<Integer> counts = new TreeSet<Integer>(this.numbers(matcher.group(2).split(",")));
            if (matcher.group(5) != null) {
                count = count % (Integer)counts.last() + 1;
            }
            if (counts.contains(count)) {
                String errorText = matcher.group(1);
                if ("ConnectException".equals(errorText)) {
                    throw new ConnectException("Artificial Failure");
                }
                if ("CancelException".equals(errorText)) {
                    throw new CancelException();
                }
                if ("RemoteException".equals(errorText)) {
                    throw new RemoteException("Artificial Failure");
                }
                DPSErrorEnum error = DPSErrorEnum.valueOf(errorText);
                throw new DPSException(error);
            }
        }
    }

    private List<Integer> numbers(String[] strings) {
        ArrayList<Integer> result = new ArrayList<Integer>(strings.length);
        for (String string : strings) {
            result.add(Integer.parseInt(string));
        }
        return result;
    }

    class MethodCounter {
        Map<String, Integer> map = new HashMap<String, Integer>();

        MethodCounter() {
        }

        public Integer get(String key) {
            Integer result = this.map.get(key);
            if (result == null) {
                result = 0;
            }
            this.map.put(key, result + 1);
            return result;
        }
    }
}

