/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.service;

import com.selima.fbi.CancelException;
import com.selima.fbi.DPSType;
import com.selima.fbi.service.DPSErrorEnum;
import com.selima.fbi.service.DPSException;
import com.selima.fbi.service.FakeToken;
import com.selima.fbi.service.IDpsClient;
import com.selima.fbi.service.IFakeDatabase;
import com.selima.fbi.service.IFakeDatabaseIterator;
import com.selima.fbi.service.IFakeServiceContext;
import com.selima.fbi.soap.ISAMLTokenOwner;
import java.io.IOException;
import java.io.StringReader;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FakeDpsClient
implements IDpsClient {
    ISAMLTokenOwner samlOwner;
    IFakeServiceContext context;
    DocumentBuilder documentBuilder;

    FakeDpsClient(ISAMLTokenOwner samlOwner, IFakeServiceContext context) {
        this.samlOwner = samlOwner;
        this.context = context;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            this.documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public long DPSretrieve(int version, String vendorID, String service, String entityType, String entity, String dataType, long got, int nItems, List<Element> data) throws DPSException, RemoteException, ConnectException, CancelException {
        this.pretendLatency();
        this.context.checkArtificialFailure("DPSretrieve");
        String username = this.checkToken();
        this.checkVersion(version);
        this.checkVendorId(vendorID);
        this.checkService(service);
        this.checkEntityType(entityType);
        this.checkEntity(entity, username);
        this.checkDataType(dataType);
        this.checkGot(got);
        this.checkNItems(nItems);
        if (entity.length() > 0) {
            IFakeDatabaseIterator it = this.context.getFakeDatabase().retrieve(entity, dataType, got, nItems);
            while (it.hasNext()) {
                data.add(this.parse((String)it.next()));
            }
            return it.getSequenceNumber();
        }
        TreeSet<ComparableIterator> its = new TreeSet<ComparableIterator>();
        for (String empRef : this.context.getAAModel().getEmployers(username)) {
            IFakeDatabaseIterator it = this.context.getFakeDatabase().retrieve(empRef, dataType, got, nItems);
            if (!it.hasNext()) continue;
            its.add(new ComparableIterator(it));
        }
        long result = got;
        for (int fetched = 0; !its.isEmpty() && fetched < nItems; ++fetched) {
            ComparableIterator it = (ComparableIterator)its.first();
            its.remove(it);
            result = it.nextSequenceNumber();
            data.add(this.parse(it.next()));
            if (!it.hasNext()) continue;
            its.add(it);
        }
        return result;
    }

    @Override
    public int DPSquery(int version, String vendorID, String service, String entityType, String entity, String dataType, long got) throws DPSException, RemoteException, ConnectException, CancelException {
        int result;
        this.pretendLatency();
        this.context.checkArtificialFailure("DPSquery");
        String username = this.checkToken();
        this.checkVersion(version);
        this.checkVendorId(vendorID);
        this.checkService(service);
        this.checkEntityType(entityType);
        this.checkEntity(entity == null ? "" : entity, username);
        this.checkDataType(dataType);
        this.checkGot(got);
        if (entity != null && !entity.isEmpty()) {
            result = this.countMessages(entity, dataType, got);
        } else {
            result = 0;
            for (String empRef : this.context.getAAModel().getEmployers(username)) {
                result += this.countMessages(empRef, dataType, got);
            }
        }
        return result;
    }

    @Override
    public long DPSdate2Index(int version, String vendorID, String service, String entityType, String entity, String dataType, Calendar date) throws DPSException, RemoteException, ConnectException, CancelException {
        long result;
        this.pretendLatency();
        this.context.checkArtificialFailure("DPSdate2Index");
        String username = this.checkToken();
        this.checkVersion(version);
        this.checkVendorId(vendorID);
        this.checkService(service);
        this.checkEntityType(entityType);
        this.checkEntity(entity == null ? "" : entity, username);
        this.checkDataType(dataType);
        this.checkDate(date);
        if (entity != null && !entity.isEmpty()) {
            result = this.context.getFakeDatabase().data2index(entity, dataType, date);
        } else {
            result = 0L;
            for (String empRef : this.context.getAAModel().getEmployers(username)) {
                long value = this.context.getFakeDatabase().data2index(empRef, dataType, date);
                if (value <= result) continue;
                result = value;
            }
        }
        return result;
    }

    @Override
    public void cancel() {
    }

    private String checkToken() throws DPSException {
        String tokenText = this.samlOwner.getSAMLToken();
        if (tokenText == null) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_INVALID_TOKEN);
        }
        FakeToken token = new FakeToken(tokenText);
        if (!token.isValid()) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_TOKEN_AUTHENTICATION);
        }
        return token.getUsername();
    }

    private void checkVersion(int version) throws DPSException {
        if (version != 1) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_UNKNOWN_VERSION);
        }
    }

    private void checkVendorId(String vendorId) throws DPSException {
        if (vendorId == null || !Pattern.matches("\\d{2,4}", vendorId)) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_INVALID_VENDOR_ID);
        }
    }

    private void checkService(String service) throws DPSException {
        if (service == null || service.length() == 0) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_INVALID_SERVICE);
        }
        if (!"PAYE".equals(service)) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_UNKNOWN_SERVICE);
        }
    }

    private void checkEntityType(String entityType) throws DPSException {
        if (entityType == null || entityType.length() == 0) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_MISSING_ENTITYTYPE);
        }
        if (!"EmpRef".equals(entityType)) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_REFERENCE_TYPE);
        }
    }

    private void checkEntity(String entity, String username) throws DPSException {
        if (entity == null) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_MISSING_ENTITY);
        }
        if (entity.length() > 0 && !this.context.getAAModel().authorize(username, entity)) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_UNAUTHORISED_REFERENCE);
        }
    }

    private void checkDataType(String dataType) throws DPSException {
        if (dataType == null || dataType.length() == 0) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_MISSING_DATATYPE);
        }
        try {
            DPSType.valueOf(dataType);
        }
        catch (IllegalArgumentException e) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_UNKNOWN_DATATYPE);
        }
    }

    private void checkDate(Calendar date) throws DPSException {
        if (date == null) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_DATE_INVALID);
        }
        if (new GregorianCalendar(2005, 7, 1).after(date)) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_PAST_DATE);
        }
        if (new GregorianCalendar().before(date)) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_FUTURE_DATE);
        }
    }

    private void checkGot(long got) throws DPSException {
        if (got < 0L || got >= 0x200000000L) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_INVALID_GOT);
        }
    }

    private void checkNItems(int nItems) throws DPSException {
        if (nItems < 0) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_INVALID_NITEMS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pretendLatency() throws DPSException {
        int timeout = this.context.getCallTimeout();
        if (timeout > 0) {
            try {
                FakeDpsClient fakeDpsClient = this;
                synchronized (fakeDpsClient) {
                    this.wait(timeout);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DPSException(DPSErrorEnum.DPS_ERR_SERVICE_UNAVAILABLE);
            }
        }
    }

    private int countMessages(String entity, String dataType, long got) {
        int result = 0;
        IFakeDatabase db = this.context.getFakeDatabase();
        IFakeDatabaseIterator it = db.retrieve(entity, dataType, got, Integer.MAX_VALUE);
        while (it.hasNext()) {
            ++result;
            it.next();
        }
        return result;
    }

    private Element parse(String xml) {
        try {
            Document doc = this.documentBuilder.parse(new InputSource(new StringReader(xml)));
            Element element = doc.getDocumentElement();
            return element;
        }
        catch (SAXException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.documentBuilder.reset();
        }
    }

    class ComparableIterator
    implements Iterator<String>,
    Comparable<ComparableIterator> {
        String value;
        IFakeDatabaseIterator wrappedIterator;

        ComparableIterator(IFakeDatabaseIterator iterator) {
            this.wrappedIterator = iterator;
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.value != null;
        }

        @Override
        public String next() {
            String result = this.value;
            this.value = this.wrappedIterator.hasNext() ? (String)this.wrappedIterator.next() : null;
            return result;
        }

        long nextSequenceNumber() {
            return this.wrappedIterator.getSequenceNumber();
        }

        @Override
        public int compareTo(ComparableIterator other) {
            long result = this.nextSequenceNumber() - other.nextSequenceNumber();
            return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, result));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

