/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.service;

import com.selima.fbi.CancelException;
import com.selima.fbi.service.DPSErrorEnum;
import com.selima.fbi.service.DPSException;
import com.selima.fbi.service.FakeToken;
import com.selima.fbi.service.IDpsAuthenticationClient;
import com.selima.fbi.service.IFakeServiceContext;
import com.selima.fbi.soap.ICredentialsOwner;
import com.selima.framework.util.logging.LogAPI;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.regex.Pattern;

class FakeAuthenticationClient
implements IDpsAuthenticationClient {
    ICredentialsOwner credentialsOwner;
    IFakeServiceContext context;

    FakeAuthenticationClient(ICredentialsOwner credentialsOwner, IFakeServiceContext context) {
        this.credentialsOwner = credentialsOwner;
        this.context = context;
    }

    @Override
    public String DPSrequestToken(int version, String vendorID) throws DPSException, RemoteException, ConnectException {
        try {
            this.context.checkArtificialFailure("DPSrequestToken");
        }
        catch (CancelException e) {
            LogAPI.logWarning((Throwable)e);
        }
        String username = this.credentialsOwner.getUsername();
        String password = this.credentialsOwner.getPassword();
        if (username == null || username.length() == 0 || password == null || password.length() == 0) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_INVALID_CREDENTIALS);
        }
        if (!this.context.getAAModel().authenticate(username, password)) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_CREDENTIAL_AUTHENTICATION);
        }
        if (version != 1) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_INVALID_VERSION);
        }
        if (vendorID == null || !Pattern.matches("\\d{2,4}", vendorID)) {
            throw new DPSException(DPSErrorEnum.DPS_ERR_INVALID_VENDOR_ID);
        }
        return new FakeToken(username, this.context.getTokenDuration()).toString();
    }

    @Override
    public void cancel() {
    }
}

