/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.service;

import com.selima.fbi.service.IFakeAAModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FakeAAModelImpl
implements IFakeAAModel {
    Map<String, String> credentialMap = new HashMap<String, String>();
    Map<String, List<String>> employerMap = new HashMap<String, List<String>>();

    public FakeAAModelImpl() {
        this.addUser("ISV190", "testing1", "123/AN64312", "123/1739465");
        this.addUser("ANYAGENT", "p2ssword", "123/AN64312", "123/A6");
        this.addUser("tester", "tester", "123/AN64312", "123/1739465", "123/A6");
    }

    void clear() {
        this.employerMap.clear();
        this.credentialMap.clear();
    }

    @Override
    public boolean authenticate(String username, String password) {
        String value = this.credentialMap.get(username);
        return value != null && value.equals(password);
    }

    @Override
    public boolean authorize(String username, String empref) {
        List<String> list = this.employerMap.get(username);
        return list != null && list.contains(empref);
    }

    public void addUser(String username, String password, String ... empref) {
        this.credentialMap.put(username, password);
        this.employerMap.put(username, new ArrayList<String>(Arrays.asList(empref)));
    }

    public void removeUser(String username) {
        this.credentialMap.remove(username);
        this.employerMap.remove(username);
    }

    public void addEmployer(String username, String empref) {
        this.employerMap.get(username).add(empref);
    }

    public void removeEmployer(String username, String empref) {
        this.employerMap.get(username).remove(empref);
    }

    @Override
    public String[] getEmployers(String username) {
        List<String> list = this.employerMap.get(username);
        if (list != null) {
            return list.toArray(new String[list.size()]);
        }
        return new String[0];
    }
}

