/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.service;

public enum DPSErrorEnum {
    DPS_ERR_INVALID_CREDENTIALS("MSG002", null, null, "Credentials missing or of wrong data"),
    DPS_ERR_CREDENTIAL_AUTHENTICATION("MSG004", "The credentials have failed authentication.", "Authentication", "The Government Gateway rejects the Credentials."),
    DPS_ERR_INVALID_TOKEN("MSG005", "The credential token is either missing or is of the wrong data type.", "Parameters", "Token missing or of wrong data type"),
    DPS_ERR_TOKEN_AUTHENTICATION("MSG006", "The credential token has failed authentication. It is either invalid or it has expired.", "Authentication", "Unable to authenticate token. Unable to identify the user from the token. The user must be identified so that the request can be tracked."),
    DPS_ERR_INVALID_VERSION("MSG007", "The API version is either missing or of the wrong data type.", "Parameters", "Version ID missing or of wrong data type"),
    DPS_ERR_UNKNOWN_VERSION("MSG008", "Unknown API version {VERSION}", "Parameters", "Version ID not found. The system will store a list of valid versions."),
    DPS_ERR_INVALID_VENDOR_ID("MSG009", "The vendor ID is either missing or of the wrong data type.", "Parameters", "Vendor ID missing or of wrong data type."),
    DPS_ERR_INVALID_SERVICE("MSG011", "The service ID is either missing or of the wrong data type.", "Parameters", "Service missing or of wrong data type."),
    DPS_ERR_UNKNOWN_SERVICE("MSG012", "Unknown service ID {SERVICE}.", "Parameters", "Service not found. The system will store a list of valid service IDs supported by the service."),
    DPS_ERR_UNAUTHORISED_SERVICE("MSG013", "User not authorised for service {SERVICE}.", "Authorisation", "User is not authorised to use this service. The system will compare the authorisation details returned from the Government Gateway with the service requested. The user must have activated the service."),
    DPS_ERR_MISSING_ENTITY("MSG014", "No customer reference for customer reference type {ENTITYTYPE}. Supply both or neither.", "Parameters", "No customer reference supplied but the customer reference type is populated."),
    DPS_ERR_REFERENCE_TYPE("MSG015", "Unknown customer reference type {ENTITYTYPE} for service {SERVICE}.", "Parameters", "Customer Reference Type not found. The system will store a list references types IDs (by service) supported by the service."),
    DPS_ERR_MISSING_ENTITYTYPE("MSG016", "No customer reference type for customer reference {ENTITY}. Supply both or neither.", "Parameters", "No customer reference type supplied but the customer reference is populated."),
    DPS_ERR_UNAUTHORISED_REFERENCE("MSG017", "User not authorised for {ENTITYTYPE} {ENTITY} in service {SERVICE}", "Authorisation", "User not authorised to specified reference (when supplied). The system will check that the user is authorised to access these details. A customer could supply the wrong reference but the more likely situation is that the agent is no longer authorised for this customer."),
    DPS_ERR_MISSING_DATATYPE("MSG018", "The event type is either missing or of the wrong data type.", "Parameters", "Event type missing or of wrong data type"),
    DPS_ERR_UNKNOWN_DATATYPE("MSG019", "Unknown event type {DATATYPE} for service {SERVICE}.", "Parameters", "Event type not found. The system will store a list event types IDs (by service) supported by the service."),
    DPS_ERR_INVALID_GOT("MSG020", "The Got value {GOT} is negative or excessive. A value of zero is valid & means return all events.", "Parameters", "The last number downloaded is held as an unsigned 32-bit integer[3]. This integer must yield a number that falls within those parameters."),
    DPS_ERR_INVALID_NITEMS("MSG021", "The number of items to retrieve value {NITEMS} is negative or excessive.", "Parameters", "The last number downloaded is held as an unsigned 32-bit integer. This integer must yield a number that falls within those parameters. A value of zero is valid & means there is no limit."),
    DPS_ERR_SERVICE_UNAVAILABLE("MSG022", "This Service is currently unavailable, please try again later.", "General", "This error will be raised before the application is invoked. The unavailability could be intentionally invoked by load balancing routines."),
    DPS_ERR_DATE_INVALID("MSG023", "The date is invalid.", "Parameters", "Date invalid."),
    DPS_ERR_FUTURE_DATE("MSG024", "The date is in the future.", "Parameters", "Date in the future."),
    DPS_ERR_PAST_DATE("MSG025", "The date is before 01-Aug-2005.", "Parameters", "Date in the past (past defined as an arbitrary date to trap obvious errors, i.e. 1st August 2005)."),
    DPS_ERR_UNEXPECTED_ERROR("MSG026", "Request failed. Reason unknown.", "General", "The system encounters an unexpected error whilst processing the data."),
    DPS_ERR_INVALID_ENTITY("MSG027", "Invalid entity", "Parameters", "The customer reference is the wrong data type.");

    String code;
    String description;
    String category;
    String note;

    private DPSErrorEnum(String ... text) {
        switch (text.length) {
            case 4: {
                this.note = text[3];
            }
            case 3: {
                this.category = text[2];
            }
            case 2: {
                this.description = text[1];
            }
            case 1: {
                this.code = text[0];
            }
        }
    }

    public boolean isParameters() {
        return "Parameters".equals(this.category);
    }

    public boolean isAuthorisation() {
        return "Authorisation".equals(this.category);
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCategory() {
        return this.category;
    }

    public String getNote() {
        return this.note;
    }
}

