/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.service;

import com.selima.fbi.CancelException;
import com.selima.fbi.MailServiceConfig;
import com.selima.framework.util.logging.LogAPI;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.JSSESocketFactory;
import org.apache.axis.components.net.SecureSocketFactory;

public abstract class AxisSocketClosingClient {
    static volatile Socket actualSocket;
    static Thread connectingThread;

    void checkCancel(AxisFault fault) throws CancelException {
        if (fault.getCause() instanceof SocketException && ("socket closed".equals(fault.getCause().getMessage()) || "Socket is closed".equals(fault.getCause().getMessage()))) {
            throw new CancelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Class<AxisSocketClosingClient> clazz = AxisSocketClosingClient.class;
        synchronized (AxisSocketClosingClient.class) {
            if (actualSocket != null) {
                try {
                    actualSocket.close();
                }
                catch (IOException e) {
                    LogAPI.logSevere((Throwable)e);
                }
                finally {
                    actualSocket = null;
                }
            } else if (connectingThread != null) {
                connectingThread.interrupt();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        AxisProperties.setProperty((String)"axis.socketSecureFactory", (String)ClosableSSLSocketFactory.class.getName());
    }

    public static class TrustedSSLSocketFactory
    extends JSSESocketFactory {
        TrustedSSLSocketFactory(Hashtable props) {
            super(props);
        }

        protected void initFactory() throws IOException {
            try {
                KeyStore trustStore = KeyStore.getInstance("JKS");
                trustStore.load(MailServiceConfig.getResourceAsStream(MailServiceConfig.getInitParameter("com.selima.fbi.trustStore")), MailServiceConfig.getInitParameter("com.selima.fbi.trustStorePassword").toCharArray());
                TrustManagerFactory selimaTrustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                selimaTrustManagerFactory.init(trustStore);
                TrustManagerFactory defaultTrustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                defaultTrustManagerFactory.init((KeyStore)null);
                SSLContext sslContext = SSLContext.getInstance("TLS");
                ArrayList trustManagers = new ArrayList();
                Collections.addAll(trustManagers, defaultTrustManagerFactory.getTrustManagers());
                Collections.addAll(trustManagers, selimaTrustManagerFactory.getTrustManagers());
                sslContext.init(null, trustManagers.toArray(new TrustManager[0]), null);
                this.sslFactory = sslContext.getSocketFactory();
            }
            catch (GeneralSecurityException e) {
                LogAPI.logSevere((Throwable)e);
                super.initFactory();
            }
        }
    }

    public static class ClosableSSLSocketFactory
    implements SecureSocketFactory {
        JSSESocketFactory wrappedFactory;

        public ClosableSSLSocketFactory(Hashtable props) {
            this.wrappedFactory = new TrustedSSLSocketFactory(props);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket create(String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL) throws Exception {
            Class<AxisSocketClosingClient> clazz = AxisSocketClosingClient.class;
            synchronized (AxisSocketClosingClient.class) {
                connectingThread = Thread.currentThread();
                actualSocket = null;
                // ** MonitorExit[var5_5] (shouldn't be in output)
                Socket socket = null;
                try {
                    socket = this.wrappedFactory.create(host, port, otherHeaders, useFullURL);
                }
                finally {
                    Class<AxisSocketClosingClient> clazz2 = AxisSocketClosingClient.class;
                    synchronized (AxisSocketClosingClient.class) {
                        connectingThread = null;
                        actualSocket = socket;
                        if (Thread.interrupted()) {
                            throw new SocketException("Socket is closed");
                        }
                        // ** MonitorExit[var6_7] (shouldn't be in output)
                    }
                }
                return actualSocket;
            }
        }
    }
}

