/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.service;

import com.selima.fbi.service.DPSErrorEnum;
import com.selima.fbi.service.DPSException;
import com.selima.framework.util.logging.LogAPI;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.apache.axis.AxisFault;
import org.w3c.dom.Element;

public class Axis2DPSErrorTranslator
implements InvocationHandler {
    Object wrappedStub;

    Axis2DPSErrorTranslator(Object stub) {
        this.wrappedStub = stub;
    }

    public static <T> T wrapStub(T stub, Class<T> type) {
        return type.cast(Proxy.newProxyInstance(stub.getClass().getClassLoader(), new Class[]{type}, (InvocationHandler)new Axis2DPSErrorTranslator(stub)));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.wrappedStub, args);
        }
        catch (InvocationTargetException e) {
            DPSException dpse;
            Throwable cause = e.getCause();
            if (cause instanceof AxisFault && (dpse = Axis2DPSErrorTranslator.translate((AxisFault)cause)) != null) {
                throw dpse;
            }
            throw cause;
        }
    }

    public static DPSException translate(AxisFault axisFault) {
        Element[] details = axisFault.getFaultDetails();
        if (details != null) {
            ArrayList<String> descs = new ArrayList<String>(details.length);
            ArrayList<DPSErrorEnum> errs = new ArrayList<DPSErrorEnum>(details.length);
            for (int i = 0; i < details.length; ++i) {
                DPSErrorInfo info = Axis2DPSErrorTranslator.translate(details[i]);
                if (info == null) continue;
                errs.add(info.error);
                descs.add(info.description);
            }
            if (errs.size() > 0) {
                return new DPSException((Throwable)axisFault, errs.toArray(new DPSErrorEnum[errs.size()]), descs.toArray(new String[descs.size()]));
            }
        }
        return null;
    }

    private static DPSErrorInfo translate(Element detail) {
        if ("DPSerror".equals(detail.getLocalName()) && "http://www.govtalk.gov.uk/taxation/DPSerror/1".equals(detail.getNamespaceURI())) {
            String errorCode = detail.getAttribute("errorCode");
            if (errorCode != null) {
                try {
                    DPSErrorEnum error = DPSErrorEnum.valueOf(errorCode);
                    return new DPSErrorInfo(error, detail.getAttribute("description"));
                }
                catch (IllegalArgumentException iae) {
                    LogAPI.logWarning((String)("Unexpected value of 'errorCode': " + errorCode));
                }
            } else {
                LogAPI.logWarning((String)"Missing 'errorCode' in DPSerror");
            }
        } else {
            LogAPI.logWarning((String)("Unexpected SOAPFault detail " + detail));
        }
        return null;
    }

    private static class DPSErrorInfo {
        DPSErrorEnum error;
        String description;

        DPSErrorInfo(DPSErrorEnum error, String description) {
            this.description = description;
            this.error = error;
        }
    }
}

