/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.service;

import com.selima.fbi.CancelException;
import com.selima.fbi.service.DPSException;
import com.selima.fbi.service.IDpsClient;
import com.selima.fbi.soap.ISAMLTokenOwner;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.List;
import org.w3c.dom.Element;

public abstract class Abstract_DPS_ErrorCorrector
implements IDpsClient {
    protected IDpsClient wrappedClient;
    protected ISAMLTokenOwner samlOwner;

    protected Abstract_DPS_ErrorCorrector(IDpsClient dpsClient, ISAMLTokenOwner samlOwner) {
        this.wrappedClient = dpsClient;
        this.samlOwner = samlOwner;
    }

    @Override
    public long DPSretrieve(int version, String vendorID, String service, String entityType, String entity, String dataType, long got, int nItems, List<Element> data) throws CancelException, DPSException, RemoteException, ConnectException {
        try {
            return this.wrappedClient.DPSretrieve(version, vendorID, service, entityType, entity, dataType, got, nItems, data);
        }
        catch (RuntimeException e) {
            this.analyzeError(vendorID, entityType, entity, this.samlOwner.getSAMLToken(), e);
            throw e;
        }
        catch (RemoteException e) {
            this.analyzeError(vendorID, entityType, entity, this.samlOwner.getSAMLToken(), e);
            throw e;
        }
    }

    @Override
    public int DPSquery(int version, String vendorID, String service, String entityType, String entity, String dataType, long got) throws CancelException, DPSException, RemoteException, ConnectException {
        try {
            return this.wrappedClient.DPSquery(version, vendorID, service, entityType, entity, dataType, got);
        }
        catch (RuntimeException e) {
            this.analyzeError(vendorID, entityType, entity, this.samlOwner.getSAMLToken(), e);
            throw e;
        }
        catch (RemoteException e) {
            this.analyzeError(vendorID, entityType, entity, this.samlOwner.getSAMLToken(), e);
            throw e;
        }
    }

    @Override
    public long DPSdate2Index(int version, String vendorID, String service, String entityType, String entity, String dataType, Calendar date) throws CancelException, DPSException, RemoteException, ConnectException {
        try {
            return this.wrappedClient.DPSdate2Index(version, vendorID, service, entityType, entity, dataType, date);
        }
        catch (RuntimeException e) {
            this.analyzeError(vendorID, entityType, entity, this.samlOwner.getSAMLToken(), e);
            throw e;
        }
        catch (RemoteException e) {
            this.analyzeError(vendorID, entityType, entity, this.samlOwner.getSAMLToken(), e);
            throw e;
        }
    }

    @Override
    public void cancel() {
        this.wrappedClient.cancel();
    }

    protected abstract void analyzeError(String var1, String var2, String var3, String var4, Exception var5) throws DPSException, RemoteException;
}

