/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.service;

import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.service.IMailService;
import com.selima.fbi.service.MailServiceException;
import com.selima.fbi.submission.IStaticSubmissionContext;
import com.selima.fbi.submission.sender.DurableGovTalkMessageSender;
import com.selima.fbi.submission.sender.GovTalkMessageSender;
import com.selima.fbi.submission.sender.IGovTalkMessageSender;
import java.io.File;
import java.util.Map;

public abstract class AbstractMailService
implements IMailService {
    String authenticationUrl;
    String dpsUrl;
    String submissionUrl;
    boolean logEnabled;
    File loggerDir;
    int pollLimit;
    String alias;

    @Override
    public void init(Map<String, String> parameters) throws MailServiceException {
        this.authenticationUrl = parameters.get("authentication-url");
        this.submissionUrl = parameters.get("submission-url");
        this.dpsUrl = parameters.get("dps-url");
        this.alias = parameters.get("alias");
        this.loggerDir = this.loggerDir(parameters, "loggerDir");
        this.pollLimit = this.pollLimit(parameters, "pollLimit");
        this.logEnabled = Boolean.parseBoolean(parameters.get("enablelog")) || "true".equalsIgnoreCase(System.getProperty("forceEnableAxisLog", "false"));
    }

    @Override
    public IStaticSubmissionContext createSubmissionContext() {
        DurableGovTalkMessageSender sender = new DurableGovTalkMessageSender(this.createSender());
        return new StaticSubmissionContextImpl(sender, this.loggerDir, this.pollLimit, this.logEnabled);
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    protected IGovTalkMessageSender createSender() {
        if (this.submissionUrl != null) {
            return new GovTalkMessageSender(this.submissionUrl);
        }
        return new GovTalkMessageSender();
    }

    private int pollLimit(Map<String, String> parameters, String name) {
        String value = parameters.get(name);
        if (value != null && value.length() > 0) {
            return Integer.parseInt(value);
        }
        return 10;
    }

    private File loggerDir(Map<String, String> parameters, String name) {
        String logDir = parameters.get(name);
        if (logDir == null || logDir.length() == 0) {
            logDir = System.getProperty("java.io.tmpdir");
            return new File(logDir);
        }
        return new File(MailServiceConfig.getBaseDir(), logDir);
    }

    private static class StaticSubmissionContextImpl
    implements IStaticSubmissionContext {
        IGovTalkMessageSender sender;
        boolean logEnabled;
        File loggerDir;
        int pollLimit;

        StaticSubmissionContextImpl(IGovTalkMessageSender sender, File loggerDir, int pollLimit, boolean logEnabled) {
            this.sender = sender;
            this.loggerDir = loggerDir;
            this.pollLimit = pollLimit;
            this.logEnabled = logEnabled;
        }

        @Override
        public IGovTalkMessageSender getSender() {
            return this.sender;
        }

        @Override
        public File getLogDir() {
            return this.loggerDir;
        }

        @Override
        public int getStepLimit() {
            return this.pollLimit;
        }

        @Override
        public boolean isLogEnabled() {
            return this.logEnabled;
        }
    }
}

