/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.sender;

import com.selima.fbi.core.SenderType;
import com.selima.fbi.sender.IModifiableSenderDetails;
import com.selima.fbi.sender.ModifiableAgent;
import com.selima.fbi.sender.ModifiableContact;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import com.selima.framework.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlRootElement(name="SenderDetails")
public class SenderDetailsImpl
implements IModifiableSenderDetails {
    private String storeId;
    private ModifiableAgent agent;
    private ModifiableContact principal;
    private ArrayList<String> useForEmpRefs;
    private SenderType senderType;
    private String label;
    private transient EventBroadcast<ChangeListener> listeners = EventBroadcastFactory.createEventBroadcast(ChangeListener.class);

    public SenderDetailsImpl() {
        this(null, null, null, null, null, null);
    }

    public SenderDetailsImpl(String storeId, ModifiableAgent agent, ModifiableContact principal, SenderType senderType, List<String> useForEmpRefs, String label) {
        this.storeId = storeId;
        this.agent = agent;
        this.principal = principal;
        this.senderType = senderType;
        this.useForEmpRefs = Util.toArrayList(useForEmpRefs);
        this.label = label;
    }

    @Override
    public ModifiableAgent getAgent() {
        return this.agent;
    }

    @Override
    @XmlElement(name="Agent", required=false)
    public void setAgent(ModifiableAgent agent) {
        this.agent = agent;
    }

    @Override
    public ModifiableContact getPrincipal() {
        return this.principal;
    }

    @Override
    @XmlElement(name="Principal", required=false)
    public void setPrincipal(ModifiableContact principal) {
        this.principal = principal;
    }

    @Override
    public SenderType getSenderType() {
        return this.senderType;
    }

    @Override
    @XmlElement(name="SenderType", required=true)
    public void setSenderType(SenderType senderType) {
        this.senderType = senderType;
    }

    public List<String> getEmpRefs() {
        return this.useForEmpRefs;
    }

    @Override
    public List<String> getAllEmpRefs() {
        return Collections.unmodifiableList(this.useForEmpRefs);
    }

    @XmlElementWrapper(name="EmpRefs")
    @XmlElement(name="EmpRef", required=false)
    public void setEmpRefs(List<String> useForEmpRefs) {
        this.useForEmpRefs = Util.toArrayList(useForEmpRefs);
        ((ChangeListener)this.listeners.getListener()).stateChanged(new ChangeEvent(this));
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    @XmlElement(name="Label", required=false)
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getStoreSpace() {
        return null;
    }

    @Override
    public String getStoreId() {
        return this.storeId;
    }

    @Override
    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    @Override
    public String[] getValidationErrors() {
        String[] errors;
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (this.senderType == null) {
            validationErrors.add("Sender type is missing.");
        }
        if (this.principal != null && (errors = this.principal.getValidationErrors()) != null && errors.length > 0) {
            for (String error : errors) {
                validationErrors.add("Principal: " + error);
            }
        }
        if (this.agent != null && (errors = this.agent.getValidationErrors()) != null && errors.length > 0) {
            validationErrors.addAll(Arrays.asList(errors));
        }
        return validationErrors.toArray(new String[0]);
    }

    @Override
    public boolean isValid() {
        return this.getValidationErrors().length == 0;
    }

    public int hashCode() {
        return String.valueOf(this.storeId).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SenderDetailsImpl) {
            SenderDetailsImpl other = (SenderDetailsImpl)obj;
            return Util.equals((Object)this.storeId, (Object)other.storeId);
        }
        return false;
    }

    @Override
    public void addEmpRef(String empRef) {
        this.useForEmpRefs.add(empRef);
        ((ChangeListener)this.listeners.getListener()).stateChanged(new ChangeEvent(this));
    }

    @Override
    public void addEmpRefListener(ChangeListener listener) {
        this.listeners.addListener((Object)listener);
    }

    @Override
    public void removeEmpRefListener(ChangeListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    @Override
    public int getEmpRefCount() {
        return this.useForEmpRefs.size();
    }

    @Override
    public String getEmpRef(int index) {
        return this.useForEmpRefs.get(index);
    }

    @Override
    public void setEmpRef(int index, String empRefs) {
        this.useForEmpRefs.set(index, empRefs);
        ((ChangeListener)this.listeners.getListener()).stateChanged(new ChangeEvent(this));
    }

    @Override
    public void removeEmpRef(int index) {
        this.useForEmpRefs.remove(index);
        ((ChangeListener)this.listeners.getListener()).stateChanged(new ChangeEvent(this));
    }
}

