/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.release_notes;

import com.selima.fbi.release_notes.Composer;
import java.io.File;
import java.io.IOException;
import java.util.GregorianCalendar;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ComposerTask
extends Task {
    Composer composer = new Composer();

    public void setProjectServerURL(String projectServerURL) {
        this.composer.projectServerURL = projectServerURL;
    }

    public void setOldestVersion(String oldestVersion) {
        GregorianCalendar value = this.parse(oldestVersion);
        if (value != null) {
            value.set(11, 0);
            value.set(12, 0);
            value.set(13, 0);
            value.set(14, 0);
            this.composer.oldestVersion = value.getTime();
        }
    }

    public void setNewestVersion(String newestVersion) {
        this.composer.newestVersionName = newestVersion;
        GregorianCalendar value = this.parse(newestVersion);
        if (value != null) {
            value.set(11, 0);
            value.set(12, 0);
            value.set(13, 0);
            value.set(14, 0);
            value.add(5, 1);
            this.composer.newestVersion = value.getTime();
        }
    }

    public void setUsername(String username) {
        this.composer.username = username;
    }

    public void setPassword(String password) {
        this.composer.password = password;
    }

    public void setPageTemplate(File pageTemplate) {
        this.composer.pageTemplate = pageTemplate;
    }

    public void setOutputFile(File outputFile) {
        this.composer.outputFile = outputFile;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        if (httpProxyHost.length() > 0) {
            this.composer.httpProxyHost = httpProxyHost;
        }
    }

    public void setHttpProxyPort(String httpProxyPort) {
        if (httpProxyPort.length() > 0) {
            try {
                this.composer.httpProxyPort = Integer.parseInt(httpProxyPort);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    public void setHttpProxyUser(String httpProxyUser) {
        if (httpProxyUser.length() > 0) {
            this.composer.httpProxyUser = httpProxyUser;
        }
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        if (httpProxyPassword.length() > 0) {
            this.composer.httpProxyPassword = httpProxyPassword;
        }
    }

    private GregorianCalendar parse(String version) {
        String[] split = version.split("\\.");
        try {
            return new GregorianCalendar(2000 + Integer.parseInt(split[0]), Integer.parseInt(split[1]) - 1, Integer.parseInt(split[2]));
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void execute() throws BuildException {
        try {
            this.composer.writeReleaseNotes();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public static void main(String[] args) {
        ComposerTask composerTask = new ComposerTask();
        composerTask.setNewestVersion("13.12.1");
        composerTask.setOutputFile(new File("/tmp/release.notes.html"));
        composerTask.execute();
    }
}

