/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.release_notes;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class Composer {
    String projectServerURL = "http://devserver.selgrp.local";
    private static DateFormat df = new SimpleDateFormat("dd/MM/yyyy");
    Date oldestVersion = new GregorianCalendar(2009, 4, 9).getTime();
    String newestVersionName = null;
    Date newestVersion = new GregorianCalendar(2100, 11, 31).getTime();
    String username = "Vitek";
    String password = "A396oV9S";
    File pageTemplate = new File("config/default/releasenotes.html");
    File outputFile = new File("C://releasenotes.html");
    String httpProxyHost;
    String httpProxyUser;
    String httpProxyPassword;
    int httpProxyPort;
    final String newLine = System.getProperty("line.separator");

    List<Release> readReleases() throws IOException, SVNException {
        DAVRepositoryFactory.setup();
        SVNRepository svnRepository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)"http://devserver.selgrp.local/svn/selima/fbi/tags"));
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)this.username, (String)this.password);
        svnRepository.setAuthenticationManager(authManager);
        Collection entries = svnRepository.getDir(".", -1L, (SVNProperties)null, (Collection)null);
        ArrayList<Release> result = new ArrayList<Release>(entries.size());
        for (SVNDirEntry entry : entries) {
            result.add(new Release(entry.getName(), entry.getDate()));
            if (!entry.getName().equals(this.newestVersionName)) continue;
            this.newestVersion = entry.getDate();
        }
        return result;
    }

    private String readTabSeparatedReport() throws IOException {
        System.setProperty("javax.net.ssl.trustStore", "security/trustedcerts");
        System.setProperty("javax.net.ssl.trustStorePassword", "password");
        URL tracUrl = new URL(this.projectServerURL);
        HttpClientParams params = new HttpClientParams();
        params.setAuthenticationPreemptive(true);
        HttpClient httpClient = new HttpClient(params);
        HostConfiguration hostConfiguration = new HostConfiguration();
        hostConfiguration.setHost(new HttpHost(tracUrl.getHost(), tracUrl.getPort()));
        if (this.httpProxyHost != null) {
            hostConfiguration.setProxy(this.httpProxyHost, this.httpProxyPort);
        }
        httpClient.setHostConfiguration(hostConfiguration);
        httpClient.getState().setCredentials(new AuthScope(tracUrl.getHost(), tracUrl.getPort()), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        if (this.httpProxyUser != null) {
            httpClient.getState().setProxyCredentials(new AuthScope(this.httpProxyHost, this.httpProxyPort), (Credentials)new NTCredentials(this.httpProxyUser, this.httpProxyPassword, this.httpProxyHost, ""));
        }
        GetMethod getMethod = new GetMethod(this.projectServerURL + "/trac/login");
        getMethod.setFollowRedirects(true);
        getMethod.setDoAuthentication(true);
        httpClient.executeMethod((HttpMethod)getMethod);
        getMethod = new GetMethod(this.projectServerURL + "/trac/report/10?format=tab");
        httpClient.executeMethod((HttpMethod)getMethod);
        return getMethod.getResponseBodyAsString();
    }

    private List<Ticket> parseTickets(String tabSeparatedText) throws IOException {
        LinkedList<Ticket> result = new LinkedList<Ticket>();
        BufferedReader reader = new BufferedReader(new StringReader(tabSeparatedText));
        List<String> headers = null;
        String line = reader.readLine();
        while (line != null) {
            String[] strings = line.split("\t");
            if (headers == null) {
                headers = Arrays.asList(strings);
            } else {
                String ticket = strings[headers.indexOf("ticket")];
                String summary = strings[headers.indexOf("summary")];
                String modified = strings[headers.indexOf("modified")];
                String resolution = strings[headers.indexOf("resolution")];
                if ("fixed".equals(resolution)) {
                    Date modifiedDate = null;
                    try {
                        String day = modified.substring(8, 10);
                        String mon = modified.substring(5, 7);
                        String year = modified.substring(0, 4);
                        modifiedDate = df.parse(day + "/" + mon + "/" + year);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    result.add(new Ticket("#" + ticket + " " + summary, this.projectServerURL + "/trac/ticket/" + ticket, modifiedDate));
                }
            }
            line = reader.readLine();
        }
        return result;
    }

    private SortedMap<Release, SortedSet<Ticket>> ticketsByReleases(List<Release> releases, List<Ticket> tickets) {
        TreeMap map = new TreeMap();
        for (Release release : releases) {
            map.put(release.date, new TreeSet());
        }
        for (Ticket ticket : tickets) {
            Map.Entry entry = map.ceilingEntry(ticket.date);
            if (entry == null) continue;
            ((SortedSet)entry.getValue()).add(ticket);
        }
        TreeMap<Release, SortedSet<Ticket>> result = new TreeMap<Release, SortedSet<Ticket>>(new Comparator<Release>(){

            @Override
            public int compare(Release o1, Release o2) {
                return o2.compareTo(o1);
            }
        });
        Release oldest = new Release("Oldest", this.oldestVersion);
        Release newest = new Release("Newest", this.newestVersion);
        for (Release release : releases) {
            if (release.compareTo(oldest) < 0 || release.compareTo(newest) > 0) continue;
            result.put(release, (SortedSet<Ticket>)map.get(release.date));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeReleaseNotes() throws IOException {
        StringBuilder prefix = new StringBuilder();
        StringBuilder postfix = new StringBuilder();
        StringBuilder buffer = prefix;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.pageTemplate)));){
            String line = reader.readLine();
            while (line != null) {
                if (line.contains("<!-- Page content beginning -->")) {
                    buffer.append(line).append(this.newLine);
                    buffer = new StringBuilder();
                } else if (line.contains("<!-- Page content end -->")) {
                    buffer = postfix;
                    buffer.append(this.newLine).append(line);
                } else {
                    buffer.append(line);
                }
                buffer.append(this.newLine);
                line = reader.readLine();
            }
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.outputFile)));){
            writer.append(prefix);
            this.writeReleaseNotes(writer);
            writer.append(postfix);
        }
    }

    void writeStart(Appendable out) throws IOException {
        out.append("<table width='97%' align='right' style='color: #808080'>").append(this.newLine);
    }

    void writeStart(Release release, Appendable out) throws IOException {
        out.append("<tr><td width='150' style='text-align:center'><span class='title'>").append(release.name).append("</span></td></tr>").append(this.newLine);
    }

    void writeEnd(Release release, Appendable out) throws IOException {
    }

    void write(Ticket ticket, Appendable out) throws IOException {
        out.append("<tr><td>&nbsp;</td><td style='text-align:left'>").append("<a href='").append(ticket.url).append("'>").append(ticket.name).append("</a>").append("</td></tr>").append(this.newLine);
    }

    void writeEnd(Appendable out) throws IOException {
        out.append("</table>");
    }

    void writeReleaseNotes(Appendable out) throws IOException {
        try {
            List<Release> releases = this.readReleases();
            String tabString = this.readTabSeparatedReport();
            List<Ticket> tickets = this.parseTickets(tabString);
            SortedMap<Release, SortedSet<Ticket>> data = this.ticketsByReleases(releases, tickets);
            this.writeStart(out);
            for (Map.Entry<Release, SortedSet<Ticket>> entry : data.entrySet()) {
                this.writeStart(entry.getKey(), out);
                for (Ticket ticket : entry.getValue()) {
                    this.write(ticket, out);
                }
                this.writeEnd(entry.getKey(), out);
            }
            this.writeEnd(out);
        }
        catch (SVNException e) {
            throw new IOException(e);
        }
    }

    public static void main(String[] args) throws IOException, SVNException, URISyntaxException, XMLStreamException, ParseException {
        new Composer().writeReleaseNotes();
    }

    static class Ticket
    implements Comparable<Ticket> {
        final String name;
        final String url;
        final Date date;

        Ticket(String name, String url, Date date) {
            this.name = name;
            this.url = url;
            this.date = date;
        }

        public String toString() {
            return this.name + " " + this.date;
        }

        @Override
        public int compareTo(Ticket o) {
            if (this.date.compareTo(o.date) != 0) {
                return this.date.compareTo(o.date);
            }
            return this.url.compareTo(o.url);
        }
    }

    static class Release
    implements Comparable<Release> {
        final String name;
        final Date date;

        Release(String name, Date date) {
            this.name = name;
            this.date = date;
        }

        public String toString() {
            return this.date + " " + this.name;
        }

        @Override
        public int compareTo(Release release) {
            return this.date.compareTo(release.date);
        }
    }
}

