/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.u2;

import asjava.uniobjects.UniFile;
import asjava.uniobjects.UniSession;
import com.selima.fbi.CancelException;
import com.selima.fbi.core.GenderEnum;
import com.selima.fbi.core.YesNoEnum;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.u2.PayrollDataFormatException;
import com.selima.fbi.plugin.u2.UniverseRPCException;
import com.selima.fbi.plugin.u2.UniverseRecord;
import java.util.Date;
import java.util.List;

public class XMLUniverseRecord
implements UniverseRecord {
    final UniverseRecord wrappedRecord;
    final UniSession uniSession;
    final UniFile uniFile;

    XMLUniverseRecord(UniSession uniSession, UniFile file, UniverseRecord wrappedRecord) {
        this.uniFile = file;
        this.uniSession = uniSession;
        this.wrappedRecord = wrappedRecord;
    }

    @Override
    public Date readDate(String column) throws UniverseRPCException, PayrollDataFormatException, CancelException, PluginException {
        return this.wrappedRecord.readDate(column);
    }

    @Override
    public String readFormattedNumber(String column, String format) throws UniverseRPCException, PayrollDataFormatException, CancelException, PluginException {
        return this.wrappedRecord.readFormattedNumber(column, format);
    }

    @Override
    public GenderEnum readGender(String column) throws UniverseRPCException, CancelException, PayrollDataFormatException, PluginException {
        return this.wrappedRecord.readGender(column);
    }

    @Override
    public List<Integer> readMultivaluedIntegers(String column) throws UniverseRPCException, CancelException, PluginException {
        return this.wrappedRecord.readMultivaluedIntegers(column);
    }

    @Override
    public List<YesNoEnum> readMultivaluedYesNo(String column) throws UniverseRPCException, CancelException, PluginException {
        return this.wrappedRecord.readMultivaluedYesNo(column);
    }

    @Override
    public List<Number> readMultivaluedNumbers(String column) throws UniverseRPCException, PayrollDataFormatException, CancelException, PluginException {
        return this.wrappedRecord.readMultivaluedNumbers(column);
    }

    @Override
    public List<Date> readMultivaluedDates(String column) throws UniverseRPCException, PayrollDataFormatException, CancelException, PluginException {
        return this.wrappedRecord.readMultivaluedDates(column);
    }

    @Override
    public List<String> readMultivaluedStrings(String column) throws UniverseRPCException, CancelException, PluginException {
        List<String> result = this.wrappedRecord.readMultivaluedStrings(column);
        for (String string : result) {
            this.checkCharset(column, string);
        }
        return result;
    }

    @Override
    public Number readNumber(String column) throws UniverseRPCException, PayrollDataFormatException, CancelException, PluginException {
        return this.wrappedRecord.readNumber(column);
    }

    @Override
    public String readString(String column) throws UniverseRPCException, CancelException, PluginException {
        return this.checkCharset(column, this.wrappedRecord.readString(column));
    }

    @Override
    public String readString(String column, int index) throws UniverseRPCException, CancelException, PluginException {
        return this.checkCharset(column, this.wrappedRecord.readString(column, index));
    }

    @Override
    public List<String> readStrings(String ... columns) throws UniverseRPCException, CancelException, PluginException {
        List<String> result = this.wrappedRecord.readStrings(columns);
        for (String string : result) {
            try {
                this.checkCharset("", string);
            }
            catch (PayrollDataFormatException e) {
                for (String column : columns) {
                    this.checkCharset(column, this.wrappedRecord.readString(column));
                }
            }
        }
        return result;
    }

    protected String checkCharset(String column, String text) throws PayrollDataFormatException {
        if (text == null) {
            return null;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c >= ' ' && c <= '\ud7ff' || c == '\t' || c == '\n' || c == '\r' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff') continue;
            throw new PayrollDataFormatException(this.uniSession, this.uniFile, column, text);
        }
        return text;
    }
}

