/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.u2;

import asjava.uniclientlibs.UniDynArray;
import asjava.uniclientlibs.UniException;
import asjava.uniclientlibs.UniString;
import asjava.uniclientlibs.UniStringException;
import asjava.uniobjects.UniDictionary;
import asjava.uniobjects.UniFile;
import asjava.uniobjects.UniFileException;
import asjava.uniobjects.UniSelectList;
import asjava.uniobjects.UniSelectListException;
import asjava.uniobjects.UniSession;
import asjava.uniobjects.UniSessionException;
import com.selima.fbi.CancelException;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.u2.UniverseEntryBuilder;
import com.selima.fbi.plugin.u2.UniverseExecutionImpl;
import com.selima.fbi.plugin.u2.UniverseFile;
import com.selima.fbi.plugin.u2.UniverseRPCException;
import com.selima.fbi.plugin.u2.UniverseRecord;
import com.selima.fbi.plugin.u2.UniverseRecordImpl;
import com.selima.fbi.plugin.u2.XMLUniverseRecord;
import com.selima.framework.util.logging.LogAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

final class UniverseFileImpl
implements UniverseFile {
    private String fileName;
    private UniSession uniSession;
    private UniverseExecutionImpl.UniverseSessionImpl universeSession;

    UniverseFileImpl(UniverseExecutionImpl.UniverseSessionImpl universeSession, UniSession uniSession, String fileName) throws PluginException, CancelException {
        this.uniSession = uniSession;
        this.universeSession = universeSession;
        this.fileName = fileName;
        try {
            LogAPI.logFiner((String)("openFile(" + fileName + ")"));
            UniFile file = uniSession.openFile((Object)fileName);
            LogAPI.logFiner((String)("close(" + fileName + ")"));
            file.close();
        }
        catch (UniSessionException e) {
            universeSession.handleFileOpenFailure(fileName, e);
        }
        catch (UniFileException e) {
            universeSession.handleFileCloseFailure(e);
        }
        catch (RuntimeException e) {
            universeSession.checkInterrupt(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> readIds() throws PluginException, CancelException {
        LogAPI.logFiner((String)("Querying " + this.fileName));
        long time = System.currentTimeMillis();
        try {
            List<String> list = this.universeSession.executeQuery(this.fileName);
            return list;
        }
        finally {
            LogAPI.logFiner((String)("Finished in " + (System.currentTimeMillis() - time) / 1000L + " seconds"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <RecordType> List<RecordType> readRecords(List<String> ids, UniverseEntryBuilder<RecordType> builder) throws PluginException, CancelException {
        ArrayList<RecordType> result = new ArrayList<RecordType>(ids.size());
        if (ids.isEmpty()) {
            return result;
        }
        long time = System.currentTimeMillis();
        try {
            LogAPI.logFiner((String)("Retrieving " + ids.size() + " records from " + this.fileName));
            this.universeSession.checkCancel();
            UniFile uniFile = this.uniSession.openFile((Object)this.fileName);
            try {
                Map<String, Index> indexes = this.indexes(this.fileName);
                ListIterator<String> it = ids.listIterator();
                while (it.hasNext()) {
                    this.universeSession.checkCancel();
                    UniverseRecord record = new IndexedUniverseRecord(this.universeSession, this.uniSession, uniFile, indexes, it.next());
                    record = new XMLUniverseRecord(this.uniSession, uniFile, record);
                    result.add(builder.build(record));
                    LogAPI.logFinest((String)("Build " + it.nextIndex() + " of " + ids.size()));
                }
            }
            finally {
                try {
                    uniFile.close();
                }
                catch (UniFileException e) {
                    this.universeSession.checkInterrupt(e);
                    LogAPI.logSevere((Throwable)e);
                }
                catch (RuntimeException e) {
                    this.universeSession.checkInterrupt(e);
                    throw e;
                }
            }
            ArrayList<RecordType> arrayList = result;
            return arrayList;
        }
        catch (UniSessionException e) {
            this.universeSession.handleFileOpenFailure(this.fileName, e);
            throw new IllegalStateException(e);
        }
        catch (RuntimeException e) {
            this.universeSession.checkInterrupt(e);
            throw e;
        }
        finally {
            LogAPI.logFiner((String)("Finished in " + (System.currentTimeMillis() - time) / 1000L + " seconds"));
        }
    }

    @Override
    public int sizeOf() throws PluginException, CancelException {
        return this.universeSession.executeQuery(this.fileName).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String id) throws PluginException, CancelException {
        try {
            this.universeSession.checkCancel();
            UniFile file = this.uniSession.openFile((Object)this.fileName);
            try {
                this.universeSession.checkCancel();
                file.deleteRecord((Object)id);
            }
            finally {
                try {
                    file.close();
                }
                catch (UniFileException e) {
                    LogAPI.logSevere((Throwable)e);
                }
            }
        }
        catch (UniSessionException e) {
            this.universeSession.handleFileOpenFailure(this.fileName, e);
        }
        catch (UniFileException e) {
            switch (e.getErrorCode()) {
                case 30114: 
                case 45000: 
                case 45002: {
                    throw new IllegalStateException(e);
                }
            }
            this.universeSession.checkInterrupt(e);
            if (this.uniSession.getRPCError()) {
                throw new UniverseRPCException(this.uniSession, (UniException)((Object)e));
            }
            throw new PluginException(e);
        }
        catch (RuntimeException e) {
            this.universeSession.checkInterrupt(e);
            throw e;
        }
    }

    private Map<String, Index> indexes(String fileName) throws PluginException, CancelException {
        try {
            this.universeSession.checkCancel();
            UniDictionary dict = this.uniSession.openDict((Object)fileName);
            UniSelectList selectList = this.uniSession.selectList(0);
            this.universeSession.checkCancel();
            selectList.select(dict);
            HashMap<String, Index> result = new HashMap<String, Index>();
            while (true) {
                this.universeSession.checkCancel();
                UniString id = selectList.next();
                if (selectList.isLastRecordRead()) break;
                dict.setRecordID((Object)id);
                try {
                    this.universeSession.checkCancel();
                    int index = Integer.parseInt(dict.getLoc().toString());
                    this.universeSession.checkCancel();
                    result.put(id.toString(), new Index(dict.getConv(), index));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return result;
        }
        catch (UniSessionException e) {
            switch (e.getErrorCode()) {
                case 39120: {
                    this.universeSession.checkInterrupt(e);
                }
                case 14022: 
                case 30112: 
                case 30114: {
                    throw new IllegalStateException();
                }
            }
            this.universeSession.checkInterrupt(e);
            if (this.uniSession.getRPCError()) {
                throw new UniverseRPCException(this.uniSession, (UniException)((Object)e));
            }
            throw new PluginException(e);
        }
        catch (UniSelectListException e) {
            switch (e.getErrorCode()) {
                case 14023: 
                case 45000: {
                    throw new IllegalStateException();
                }
            }
            this.universeSession.checkInterrupt(e);
            if (this.uniSession.getRPCError()) {
                throw new UniverseRPCException(this.uniSession, (UniException)((Object)e));
            }
            throw new PluginException(e);
        }
        catch (UniFileException e) {
            this.universeSession.checkInterrupt(e);
            throw new IllegalStateException(e);
        }
        catch (RuntimeException e) {
            this.universeSession.checkInterrupt(e);
            throw e;
        }
    }

    private class IndexedUniverseRecord
    extends UniverseRecordImpl {
        private final UniDynArray record;
        private final Map<String, Index> indexes;

        IndexedUniverseRecord(UniverseExecutionImpl.UniverseSessionImpl universeSession, UniSession uniSession, UniFile uniFile, Map<String, Index> indexes, String id) throws PluginException, CancelException {
            super(universeSession, uniSession, uniFile, id);
            this.indexes = indexes;
            try {
                this.logFinest("file(" + uniFile.getFileName() + ").read-record(" + id + ")");
                this.record = uniSession.dynArray((Object)uniFile.read((Object)id));
            }
            catch (UniFileException e) {
                universeSession.handleFileReadError(e);
                throw new IllegalStateException(e);
            }
            catch (RuntimeException e) {
                universeSession.checkInterrupt(e);
                throw e;
            }
        }

        @Override
        public String readString(String column) throws UniverseRPCException, CancelException, PluginException {
            if (this.indexes.containsKey(column)) {
                this.universeSession.checkCancel();
                String value = this.indexes.get(column).read(this.record);
                return value == null || value.length() == 0 ? null : value;
            }
            return super.readString(column);
        }
    }

    private class Index {
        UniString oconv;
        int loc;

        Index(UniString oconv, int loc) {
            this.oconv = oconv;
            this.loc = loc;
        }

        public String read(UniDynArray record) throws UniverseRPCException, CancelException {
            UniDynArray extract = record.extract(this.loc);
            if (this.oconv.length() > 0) {
                try {
                    return UniverseFileImpl.this.uniSession.oconv((Object)extract, (Object)this.oconv).toString();
                }
                catch (UniStringException e) {
                    UniverseFileImpl.this.universeSession.checkInterrupt(e);
                    if (UniverseFileImpl.this.uniSession.getRPCError()) {
                        throw new UniverseRPCException(UniverseFileImpl.this.uniSession, (UniException)((Object)e));
                    }
                    throw new IllegalStateException(e);
                }
                catch (RuntimeException e) {
                    UniverseFileImpl.this.universeSession.checkInterrupt(e);
                    throw e;
                }
            }
            return extract.toString();
        }
    }
}

