/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.u2;

import com.selima.fbi.CancelException;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.u2.UniverseExecution;
import com.selima.fbi.plugin.u2.UniverseExecutionCache;
import com.selima.fbi.plugin.u2.UniverseExecutionImpl;
import com.selima.fbi.plugin.u2.UniverseWork;
import com.selima.fbi.user.PayrollServerSpec;
import com.selima.framework.util.logging.LogAPI;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class UniverseExecutionCacheImpl
implements UniverseExecutionCache {
    private static final int AUTO_DISCONNECT_TIMEOUT = 2000;
    Map<PayrollServerSpec, ExpiringUniverseExecution> map = new HashMap<PayrollServerSpec, ExpiringUniverseExecution>();
    Timer disconnectTimer = new Timer("Payroll-Auto-Disconnect");

    @Override
    public synchronized UniverseExecution connect(PayrollServerSpec payroll) {
        ExpiringUniverseExecution result = this.map.get(payroll);
        if (result == null) {
            LogAPI.logInfo((String)("Preparing new connection to  " + payroll + " (" + System.identityHashCode(result) + ")"));
            result = new ExpiringUniverseExecution(payroll);
            this.map.put(payroll, result);
        } else {
            LogAPI.logInfo((String)("Reusing existing connection to  " + payroll + " (" + System.identityHashCode(result) + ")"));
            result.restartTimer();
        }
        return result;
    }

    class ExpiringUniverseExecution
    implements UniverseExecution {
        final UniverseExecutionImpl execution;
        final PayrollServerSpec payroll;
        TimerTask timerTask;

        ExpiringUniverseExecution(PayrollServerSpec payroll) {
            this.execution = new UniverseExecutionImpl(payroll, false);
            this.payroll = payroll;
        }

        @Override
        public void cancel() {
            this.execution.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <ReturnType> ReturnType run(UniverseWork<ReturnType> universeWork) throws PluginException, CancelException {
            UniverseExecutionCacheImpl universeExecutionCacheImpl = UniverseExecutionCacheImpl.this;
            synchronized (universeExecutionCacheImpl) {
                this.stopTimer();
                boolean success = false;
                ReturnType result = this.execution.run(universeWork);
                success = true;
                ReturnType ReturnType = result;
                return ReturnType;
                finally {
                    if (success) {
                        this.startTimer();
                    } else {
                        this.disconnect();
                    }
                }
            }
        }

        void stopTimer() {
            if (this.timerTask != null) {
                this.timerTask.cancel();
                this.timerTask = null;
            }
        }

        void restartTimer() {
            this.stopTimer();
            this.startTimer();
        }

        void startTimer() {
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    ExpiringUniverseExecution.this.disconnectOnTimer(this);
                }
            };
            UniverseExecutionCacheImpl.this.disconnectTimer.schedule(this.timerTask, 2000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void disconnectOnTimer(TimerTask invokedTask) {
            UniverseExecutionCacheImpl universeExecutionCacheImpl = UniverseExecutionCacheImpl.this;
            synchronized (universeExecutionCacheImpl) {
                if (this.timerTask == invokedTask) {
                    this.disconnect();
                    this.timerTask = null;
                }
            }
        }

        void disconnect() {
            this.execution.disconnect();
            UniverseExecutionCacheImpl.this.map.remove(this.payroll);
            LogAPI.logInfo((String)("Disconnecting " + this.payroll + " (" + System.identityHashCode(this) + ")"));
        }
    }
}

