/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.u2;

import asjava.uniclientlibs.UniDynArray;
import asjava.uniclientlibs.UniException;
import asjava.uniobjects.UniFile;
import asjava.uniobjects.UniFileException;
import asjava.uniobjects.UniSessionException;
import asjava.uniobjects.UniTransaction;
import com.selima.fbi.CancelException;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.u2.Type19Session;
import com.selima.fbi.plugin.u2.Type19Work;
import com.selima.fbi.plugin.u2.UniverseExecution2;
import com.selima.fbi.plugin.u2.UniverseExecutionImpl;
import com.selima.fbi.plugin.u2.UniverseFileNotFoundException;
import com.selima.fbi.plugin.u2.UniverseFileType19;
import com.selima.fbi.plugin.u2.UniverseFileType19Impl;
import com.selima.fbi.plugin.u2.UniverseRPCException;
import com.selima.fbi.plugin.u2.UniverseSession;
import com.selima.fbi.plugin.u2.UniverseWork;
import com.selima.fbi.user.PayrollServerSpec;

public class UniverseExecution2Impl
extends UniverseExecutionImpl
implements UniverseExecution2 {
    public UniverseExecution2Impl(PayrollServerSpec payrollServer) {
        super(payrollServer);
    }

    @Override
    public void run(final Type19Work universeWork) throws PluginException, CancelException {
        this.run(new UniverseWork<Void>(){

            @Override
            public Void execute(UniverseSession universeSession) throws PluginException, CancelException {
                UniverseExecution2Impl.this.checkCancel();
                universeWork.execute(new UniverseSessionImpl2((UniverseExecutionImpl.UniverseSessionImpl)universeSession));
                return null;
            }
        });
    }

    @Override
    public void transaction(final Type19Work universeWork) throws PluginException, CancelException {
        this.run(new UniverseWork<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void execute(UniverseSession universeSession) throws PluginException, CancelException {
                Void void_;
                block14: {
                    UniTransaction transaction;
                    block13: {
                        UniverseSessionImpl2 universeSession2 = new UniverseSessionImpl2((UniverseExecutionImpl.UniverseSessionImpl)universeSession);
                        UniverseExecution2Impl.this.checkCancel();
                        transaction = UniverseExecution2Impl.this.uniSession.transaction();
                        boolean success = false;
                        try {
                            UniverseExecution2Impl.this.checkCancel();
                            transaction.begin();
                            UniverseExecution2Impl.this.checkCancel();
                            universeWork.execute(universeSession2);
                            success = true;
                            void_ = null;
                            if (!success) break block13;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (success) {
                                    transaction.commit();
                                } else {
                                    transaction.rollback();
                                }
                                throw throwable;
                            }
                            catch (UniException e) {
                                switch (e.getErrorCode()) {
                                    case 39120: {
                                        UniverseExecution2Impl.this.checkInterrupt(e);
                                    }
                                    case 30114: {
                                        throw new IllegalStateException(e);
                                    }
                                }
                                if (UniverseExecution2Impl.this.uniSession.getRPCError()) {
                                    throw new UniverseRPCException(UniverseExecution2Impl.this.uniSession, e);
                                }
                                throw new PluginException(e);
                            }
                            catch (RuntimeException e) {
                                UniverseExecution2Impl.this.checkInterrupt(e);
                                throw e;
                            }
                        }
                        transaction.commit();
                        break block14;
                    }
                    transaction.rollback();
                }
                return void_;
            }
        });
    }

    class UniverseSessionImpl2
    implements Type19Session {
        final UniverseExecutionImpl.UniverseSessionImpl universeSession;

        public UniverseSessionImpl2(UniverseExecutionImpl.UniverseSessionImpl universeSession) {
            this.universeSession = universeSession;
        }

        @Override
        public UniverseFileType19 universeFileType19(String name) throws CancelException, PluginException {
            this.checkCancel();
            try {
                return new UniverseFileType19Impl(this, UniverseExecution2Impl.this.uniSession, UniverseExecution2Impl.this.uniSession.openFile((Object)name));
            }
            catch (UniSessionException e) {
                this.resolveFileOpenError(name, e);
                throw new IllegalStateException();
            }
        }

        public void checkInterrupt(Throwable e) throws CancelException {
            UniverseExecution2Impl.this.checkInterrupt(e);
        }

        public void checkCancel() throws CancelException {
            UniverseExecution2Impl.this.checkCancel();
        }

        @Override
        public void createFileType19(String name) throws PluginException, CancelException {
            this.checkCancel();
            this.updateVOC();
            this.checkCancel();
            this.universeSession.executeCommand("CREATE.FILE " + name + " 19");
        }

        @Override
        public boolean fileExists(String name) throws CancelException, PluginException {
            try {
                this.checkCancel();
                UniFile file = UniverseExecution2Impl.this.uniSession.openFile((Object)name);
                this.checkCancel();
                file.close();
                return true;
            }
            catch (UniSessionException e) {
                switch (e.getErrorCode()) {
                    case 14002: {
                        return false;
                    }
                }
                this.resolveFileOpenError(name, e);
            }
            catch (UniFileException e) {
                this.resolveFileIOError(e);
            }
            catch (RuntimeException e) {
                this.checkInterrupt(e);
                throw e;
            }
            throw new IllegalStateException();
        }

        void updateVOC() throws CancelException, PluginException {
            try {
                this.checkCancel();
                UniFile voc = UniverseExecution2Impl.this.uniSession.openFile((Object)"VOC");
                this.checkCancel();
                UniDynArray body = new UniDynArray(voc.read((Object)"CREATE.FILE"));
                body.replace(4, (Object)"V");
                this.checkCancel();
                voc.write((Object)"CREATE.FILE", (Object)body);
            }
            catch (UniSessionException e) {
                this.resolveFileOpenError("VOC", e);
            }
            catch (UniFileException e) {
                this.resolveFileIOError(e);
            }
            catch (RuntimeException e) {
                this.checkInterrupt(e);
                throw e;
            }
        }

        void resolveFileIOError(UniFileException e) throws CancelException, PluginException {
            switch (e.getErrorCode()) {
                case 39120: {
                    this.checkInterrupt(e);
                }
                case 30096: 
                case 30114: 
                case 45000: 
                case 45002: {
                    throw new IllegalStateException(e);
                }
            }
            if (UniverseExecution2Impl.this.uniSession.getRPCError()) {
                throw new UniverseRPCException(UniverseExecution2Impl.this.uniSession, (UniException)e);
            }
            throw new PluginException(e);
        }

        void resolveFileOpenError(String fileName, UniSessionException e) throws CancelException, PluginException {
            switch (e.getErrorCode()) {
                case 39120: {
                    this.checkInterrupt(e);
                }
                case 14022: 
                case 30112: 
                case 30114: 
                case 45000: 
                case 45002: {
                    throw new IllegalStateException(e);
                }
                case 14002: {
                    throw new UniverseFileNotFoundException(fileName, e);
                }
            }
            this.checkInterrupt(e);
            if (UniverseExecution2Impl.this.uniSession.getRPCError()) {
                throw new UniverseRPCException(UniverseExecution2Impl.this.uniSession, (UniException)e);
            }
            throw new PluginException(e);
        }
    }
}

