/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.u2;

import com.selima.fbi.CancelException;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.u2.UniverseExecutionImpl;
import com.selima.fbi.user.PayrollServerSpec;

public class TaskLockException
extends PluginException {
    int lockNumber;
    String payrollName;
    PayrollServerSpec payroll;
    volatile UniverseExecutionImpl execution;

    TaskLockException(String payrollName, Throwable cause, PayrollServerSpec payroll, int lockNumber) {
        super("Failed to obtain Task Lock " + lockNumber + " for " + payrollName, cause);
        this.payrollName = payrollName;
        this.lockNumber = lockNumber;
        this.payroll = payroll;
    }

    public void releaseTaskLock() throws PluginException, CancelException {
        this.execution = new UniverseExecutionImpl(this.payroll, true);
        try {
            this.execution.clearTaskLock(this.lockNumber);
        }
        finally {
            this.execution = null;
        }
    }

    public String getPayrollName() {
        return this.payrollName;
    }

    public int getTaskLock() {
        return this.lockNumber;
    }

    public void cancel() {
        UniverseExecutionImpl execution = this.execution;
        if (execution != null) {
            execution.cancel();
        }
    }
}

