/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.js.builder.entry;

import com.selima.fbi.CancelException;
import com.selima.fbi.core.payebeans.BeanAddress;
import com.selima.fbi.core.payebeans.rti2014.impl.NINOVREmployeeEntry2014;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.u2.UniverseEntryBuilder;
import com.selima.fbi.plugin.u2.UniverseRecord;

public class NINOVREntryBuilder
implements UniverseEntryBuilder<NINOVREmployeeEntry2014> {
    String officeNo;
    String payeRef;
    String aoRef;

    public String getOfficeNo() {
        return this.officeNo;
    }

    public String getPayeRef() {
        return this.payeRef;
    }

    public String getAoRef() {
        return this.aoRef;
    }

    @Override
    public NINOVREmployeeEntry2014 build(UniverseRecord record) throws PluginException, CancelException {
        if (this.officeNo == null) {
            this.officeNo = record.readString("HMRC_OFFICE_NUMBER");
        }
        if (this.payeRef == null) {
            this.payeRef = record.readString("EMPLOYER_PAYE_REF");
        }
        if (this.aoRef == null) {
            this.aoRef = record.readString("EMPLOYER_ACCOUNTS_OFFICE");
        }
        NINOVREmployeeEntry2014 ninovrEntry = new NINOVREmployeeEntry2014();
        ninovrEntry.initTitle(record.readString("TITLE"));
        ninovrEntry.initFore1(this.trim(record.readString("FORENAME")));
        ninovrEntry.initFore2(this.trim(record.readString("SECOND_FORENAME")));
        ninovrEntry.initSurname(record.readString("SURNAME"));
        ninovrEntry.initNino(record.readString("NINO"));
        ninovrEntry.initBirthDate(record.readDate("DOB"));
        ninovrEntry.initGender(record.readString("GENDER"));
        ninovrEntry.initPayId(record.readString("PAYROLL_ID"));
        BeanAddress employeeAddress = new BeanAddress(record.readStrings("EMPLOYEE_ADDRESS_LINE1", "EMPLOYEE_ADDRESS_LINE2", "EMPLOYEE_ADDRESS_LINE3", "EMPLOYEE_ADDRESS_LINE4"), record.readString("EMPLOYEE_POSTCODE"), record.readString("FOREIGN_COUNTRY"));
        ninovrEntry.initAddress(employeeAddress);
        return ninovrEntry;
    }

    protected String trim(String value) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return value;
    }
}

