/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.js.builder.entry;

import com.selima.fbi.CancelException;
import com.selima.fbi.core.payebeans.impl.YesType;
import com.selima.fbi.core.payebeans.rti2016.impl.FPSEmployeeEntry2016;
import com.selima.fbi.core.payebeans.rti2016.impl.FPSEmploymentEntry2016;
import com.selima.fbi.core.payebeans.rti2016.impl.FPSLettersAndValues2016;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.js.builder.entry.AbstractFPSEntryBuilderUpto2016;
import com.selima.fbi.plugin.u2.UniverseRPCException;
import com.selima.fbi.plugin.u2.UniverseRecord;
import java.util.List;

public class FPSEntryBuilder2016
extends AbstractFPSEntryBuilderUpto2016<FPSEmployeeEntry2016, FPSLettersAndValues2016, FPSEmploymentEntry2016> {
    private List<String> lateReason;
    private List<Number> sppYTD;
    private List<Number> shppYTD;
    private List<String> flexiblyAccessingPendionRights;

    @Override
    protected FPSLettersAndValues2016 createNILettersAndValues() {
        return new FPSLettersAndValues2016();
    }

    @Override
    protected List<FPSEmploymentEntry2016> readEmployements(List<FPSLettersAndValues2016> niLettersAndValues, UniverseRecord record) throws UniverseRPCException, CancelException, PluginException {
        this.lateReason = record.readMultivaluedStrings("LATE_REPORTING_REASON");
        this.sppYTD = record.readMultivaluedNumbers("OSPP_YTD");
        this.shppYTD = record.readMultivaluedNumbers("ASPP_YTD");
        this.flexiblyAccessingPendionRights = record.readMultivaluedStrings("FLEXIBLY_ACCESSING_PENSION_RIGHTS");
        return super.readEmployements(niLettersAndValues, record);
    }

    @Override
    protected FPSEmploymentEntry2016 newFPSEmployment(int index, List<FPSLettersAndValues2016> niLettersAndValues) {
        FPSEmploymentEntry2016 result = new FPSEmploymentEntry2016((List<? extends FPSLettersAndValues2016>)niLettersAndValues);
        result.initLateReason(this.get(this.lateReason, index));
        result.initSppYTD(this.get(this.sppYTD, index));
        result.initShppYTD(this.get(this.shppYTD, index));
        result.initFlexiblyAccessingPensionRights(YesType.fromUniverse(this.get(this.flexiblyAccessingPendionRights, index)));
        return result;
    }

    @Override
    protected FPSEmployeeEntry2016 newFPSEmployee(List<FPSEmploymentEntry2016> employments, UniverseRecord record) {
        return new FPSEmployeeEntry2016((List<? extends FPSEmploymentEntry2016>)employments);
    }
}

