/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.js.builder.entry;

import com.selima.fbi.CancelException;
import com.selima.fbi.core.payebeans.BeanAddress;
import com.selima.fbi.core.payebeans.impl.AbstractEmployeeEntry;
import com.selima.fbi.core.payebeans.impl.FPSEmployeeEntry;
import com.selima.fbi.core.payebeans.impl.FPSEmploymentEntry;
import com.selima.fbi.core.payebeans.impl.FPSLettersAndValues;
import com.selima.fbi.core.payebeans.impl.YesType;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.u2.UniverseEntryBuilder;
import com.selima.fbi.plugin.u2.UniverseRPCException;
import com.selima.fbi.plugin.u2.UniverseRecord;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AbstractFPSEmployeeEntryBuilder<EmployeeType extends FPSEmployeeEntry, NILettersAndValuesType extends FPSLettersAndValues, EmploymentType extends FPSEmploymentEntry>
implements UniverseEntryBuilder<EmployeeType> {
    String officeNo;
    String payeRef;
    String aoRef;
    String sautr;
    String cotaxref;

    public String getOfficeNo() {
        return this.officeNo;
    }

    public String getPayeRef() {
        return this.payeRef;
    }

    public String getAoRef() {
        return this.aoRef;
    }

    public String getSautr() {
        return this.sautr;
    }

    public String getCotaxref() {
        return this.cotaxref;
    }

    protected abstract NILettersAndValuesType newNILettersAndValues(int var1);

    protected abstract EmploymentType newFPSEmployment(int var1, List<NILettersAndValuesType> var2);

    protected abstract EmployeeType newFPSEmployee(List<EmploymentType> var1, UniverseRecord var2);

    @Override
    public EmployeeType build(UniverseRecord record) throws PluginException, CancelException {
        this.readMessageLevelValues(record);
        List<NILettersAndValuesType> niLettersAndValues = this.readNILettersAndValues(record);
        List<EmploymentType> employements = this.readEmployements(niLettersAndValues, record);
        return this.readEmployee(employements, record);
    }

    private EmployeeType readEmployee(List<EmploymentType> employements, UniverseRecord record) throws UniverseRPCException, CancelException, PluginException {
        EmployeeType result = this.newFPSEmployee(employements, record);
        ((AbstractEmployeeEntry)result).initTitle(record.readString("TITLE"));
        ((AbstractEmployeeEntry)result).initFore1(this.trim(record.readString("FORENAME")));
        ((AbstractEmployeeEntry)result).initFore2(this.trim(record.readString("SECOND_FORENAME")));
        ((AbstractEmployeeEntry)result).initSurname(record.readString("SURNAME"));
        ((AbstractEmployeeEntry)result).initNino(record.readString("NINO"));
        ((FPSEmployeeEntry)result).initBirthDate(record.readDate("DOB"));
        ((FPSEmployeeEntry)result).initGender(record.readString("GENDER"));
        ((FPSEmployeeEntry)result).initPassport(record.readString("PASSPORT"));
        ((FPSEmployeeEntry)result).initPartnerNino(record.readString("PARTNER_NINO"));
        ((FPSEmployeeEntry)result).initPartnerFore1(record.readString("PARTNER_FORENAME"));
        ((FPSEmployeeEntry)result).initPartnerFore2(record.readString("PARTNER_SECOND_FORENAME"));
        ((FPSEmployeeEntry)result).initPartnerSurname(record.readString("PARTNER_SURNAME"));
        BeanAddress employeeAddress = new BeanAddress(record.readStrings("EMPLOYEE_ADDRESS_LINE1", "EMPLOYEE_ADDRESS_LINE2", "EMPLOYEE_ADDRESS_LINE3", "EMPLOYEE_ADDRESS_LINE4"), record.readString("EMPLOYEE_POSTCODE"), record.readString("FOREIGN_COUNTRY"));
        ((FPSEmployeeEntry)result).initAddress(employeeAddress);
        return result;
    }

    protected void readMessageLevelValues(UniverseRecord record) throws UniverseRPCException, CancelException, PluginException {
        if (this.officeNo == null) {
            this.officeNo = record.readString("HMRC_OFFICE_NUMBER");
        }
        if (this.payeRef == null) {
            this.payeRef = record.readString("EMPLOYER_PAYE_REF");
        }
        if (this.aoRef == null) {
            this.aoRef = record.readString("EMPLOYER_ACCOUNTS_OFFICE");
        }
        if (this.sautr == null) {
            this.sautr = record.readString("SAUTR");
        }
        if (this.cotaxref == null) {
            this.cotaxref = record.readString("COTAXREF");
        }
    }

    protected List<NILettersAndValuesType> readNILettersAndValues(UniverseRecord record) throws UniverseRPCException, CancelException, PluginException {
        List<String> niCategories = record.readMultivaluedStrings("NI_CATEGORY");
        List<Number> niPayTp = record.readMultivaluedNumbers("NI_PAY_TP");
        List<Number> niPayCf = record.readMultivaluedNumbers("NI_PAY_CF");
        List<Number> toLelCf = record.readMultivaluedNumbers("TO_LEL_CF");
        List<Number> toPtCf = record.readMultivaluedNumbers("TO_PT_CF");
        List<Number> erContsTp = record.readMultivaluedNumbers("ER_CONTS_TP");
        List<Number> erContsCf = record.readMultivaluedNumbers("ER_CONTS_CF");
        List<Number> eeContsTp = record.readMultivaluedNumbers("EE_CONTS_TP");
        List<Number> eeContsCf = record.readMultivaluedNumbers("EE_CONTS_CF");
        ArrayList<NILettersAndValuesType> result = new ArrayList<NILettersAndValuesType>();
        for (int i = 0; i < niCategories.size(); ++i) {
            String niCategory = this.get(niCategories, i);
            if (niCategory == null) continue;
            NILettersAndValuesType niLettersAndValues = this.newNILettersAndValues(i);
            ((FPSLettersAndValues)niLettersAndValues).initNiCat(niCategory);
            ((FPSLettersAndValues)niLettersAndValues).initGrossEarningsForNICsInPd(this.get(niPayTp, i));
            ((FPSLettersAndValues)niLettersAndValues).initGrossEarningsForNICsYTD(this.get(niPayCf, i));
            ((FPSLettersAndValues)niLettersAndValues).initAtLELYTD(this.get(toLelCf, i));
            ((FPSLettersAndValues)niLettersAndValues).initLelToPTYTD(this.get(toPtCf, i));
            ((FPSLettersAndValues)niLettersAndValues).initTotalEmpNICInPd(this.get(erContsTp, i));
            ((FPSLettersAndValues)niLettersAndValues).initTotalEmpNICYTD(this.get(erContsCf, i));
            ((FPSLettersAndValues)niLettersAndValues).initEmpeeContribnsInPd(this.get(eeContsTp, i));
            ((FPSLettersAndValues)niLettersAndValues).initEmpeeContribnsYTD(this.get(eeContsCf, i));
            result.add(niLettersAndValues);
        }
        return result;
    }

    protected List<EmploymentType> readEmployements(List<NILettersAndValuesType> niLettersAndValues, UniverseRecord record) throws UniverseRPCException, CancelException, PluginException {
        List<String> taxCodes = record.readMultivaluedStrings("TAX_CODE");
        List<String> taxBases = record.readMultivaluedStrings("TAX_BASIS");
        List<String> irregularPayments = record.readMultivaluedStrings("IRREGULAR_PAYMENT");
        List<String> payrollIds = record.readMultivaluedStrings("PAYROLL_ID");
        List<String> oldPayrollIds = record.readMultivaluedStrings("OLD_PAYROLL_ID");
        List<String> payrollIdChanged = record.readMultivaluedStrings("PAYROLL_ID_CHANGED");
        List<String> receivingOccPensions = record.readMultivaluedStrings("RECEIVING_OCC_PENSION");
        List<String> recentlyBereaved = record.readMultivaluedStrings("RECENTLY_BEREAVED");
        List<Number> occPensionAmounts = record.readMultivaluedNumbers("AMOUNT_OF_OCC_PENSION");
        List<Date> startDates = record.readMultivaluedDates("START_DATE");
        List<Date> leavingDates = record.readMultivaluedDates("LEAVING_DATE");
        List<String> studentLoans = record.readMultivaluedStrings("STUDENT_LOAN");
        List<String> stay183DaysOrMore = record.readMultivaluedStrings("LIVING_IN_UK_MORE");
        List<String> stayLessThen183Days = record.readMultivaluedStrings("LIVING_IN_UK_LESS");
        List<String> inOutUK = record.readMultivaluedStrings("WORKING_IN_AND_OUT_OF_UK");
        List<String> eeaCitizen = record.readMultivaluedStrings("EEA_OR_COMMONWEALTH");
        List<String> directorsNIC = record.readMultivaluedStrings("DIRECTORS_NIC");
        List<String> taxWsOfApptOfDirector = record.readMultivaluedStrings("DIRECTORS_TAX_WEEK");
        List<Number> taxablePTD = record.readMultivaluedNumbers("TAXABLE_PAY_TO_DATE");
        List<Number> taxPaid = record.readMultivaluedNumbers("TAX_TO_DATE");
        List<Number> studentLoanRecovered = record.readMultivaluedNumbers("STUDENT_LOAN_RECOVERED");
        List<Number> taxDeductionsOrRefunds = record.readMultivaluedNumbers("INCOME_TAX_TP");
        List<String> epm6 = record.readMultivaluedStrings("EPM6_SCHEME");
        String starterDec = record.readString("STARTER_DECLARATION");
        List<Number> benefitsTaxedViaPayrollYTD = record.readMultivaluedNumbers("BENS_TAX_VIA_PAYROLL_YTD");
        List<Number> empeePenContribnsPaidYTD = record.readMultivaluedNumbers("EE_PEN_NET_PAY_YTD");
        List<Number> empeePenContribnsNotPaidYTD = record.readMultivaluedNumbers("EE_PEN_NOT_NET_PAY_YTD");
        List<String> onStrike = record.readMultivaluedStrings("ON_STRIKE");
        List<String> unpaidAbsence = record.readMultivaluedStrings("UNPAID_ABSENCE");
        List<Number> smpYTD = record.readMultivaluedNumbers("SMP_YTD");
        List<Number> sapYTD = record.readMultivaluedNumbers("SAP_YTD");
        List<Date> paymentDates = record.readMultivaluedDates("PAY_DATE");
        List<String> paymentFrequencies = record.readMultivaluedStrings("PAY_FREQUENCY");
        List<Number> weekNos = record.readMultivaluedNumbers("PAYMENT_WEEK_NUMBER");
        List<Number> monthNos = record.readMultivaluedNumbers("PAYMENT_MONTH_NUMBER");
        List<Number> periodsCovered = record.readMultivaluedNumbers("PERIODS_COVERED");
        List<String> aggEarnings = record.readMultivaluedStrings("AGGREGATED_EARNINGS");
        List<String> paymentAfterLeaving = record.readMultivaluedStrings("PAYMENT_AFTER_LEAVING");
        List<String> hoursWorked = record.readMultivaluedStrings("NORMAL_HOURS_WORKED");
        List<Number> taxablePay = record.readMultivaluedNumbers("TAXABLE_PAY_TP");
        List<Number> nonTaxOrNICPmt = record.readMultivaluedNumbers("NON_TAX_NI_PAYMENT");
        List<Number> deductionsFromNetPay = record.readMultivaluedNumbers("DEDUCTIONS_FROM_NET_PAY");
        List<Number> payAfterStatDeductions = record.readMultivaluedNumbers("PAY_AFTER_STAT_DEDS");
        List<Number> benefitsTaxedViaPayroll = record.readMultivaluedNumbers("BENS_TAX_VIA_PAYROLL");
        List<Number> empeePenContribnsPaid = record.readMultivaluedNumbers("EE_PEN_NET_PAY");
        List<Number> itemsSubjectToClass1NIC = record.readMultivaluedNumbers("SUBJECT_TO_CLASS_ONE_NIC");
        List<Number> empeePenContribnsNotPaid = record.readMultivaluedNumbers("EE_PEN_NOT_NET_PAY");
        List<Number> studentLoanTP = record.readMultivaluedNumbers("STUDENT_LOAN_TP");
        List<String> bacsHashes = record.readMultivaluedStrings("BACS_HASH");
        List<Number> netPayments = record.readMultivaluedNumbers("NET_PAY");
        List<String> origSortCodes = record.readMultivaluedStrings("ORIG_SORT_CODE");
        List<String> recipSortCodes = record.readMultivaluedStrings("RECIP_SORT_CODE");
        ArrayList<EmploymentType> employments = new ArrayList<EmploymentType>();
        for (int i = 0; i < taxCodes.size(); ++i) {
            EmploymentType employment = this.newFPSEmployment(i, niLettersAndValues);
            ((FPSEmploymentEntry)employment).initPayId(this.get(payrollIds, i));
            ((FPSEmploymentEntry)employment).initReceivingOccPension(YesType.fromUniverse(this.get(receivingOccPensions, i)));
            ((FPSEmploymentEntry)employment).initOccPensionBereaved(YesType.fromUniverse(this.get(recentlyBereaved, i)));
            ((FPSEmploymentEntry)employment).initOccPensionAmount(this.get(occPensionAmounts, i));
            ((FPSEmploymentEntry)employment).initStartDate(this.get(startDates, i));
            ((FPSEmploymentEntry)employment).initLeavingDate(this.get(leavingDates, i));
            ((FPSEmploymentEntry)employment).initStudentLoan(YesType.fromUniverse(this.get(studentLoans, i)));
            ((FPSEmploymentEntry)employment).initStay183DaysOrMore(YesType.fromUniverse(this.get(stay183DaysOrMore, i)));
            ((FPSEmploymentEntry)employment).initStayLessThan183Days(YesType.fromUniverse(this.get(stayLessThen183Days, i)));
            ((FPSEmploymentEntry)employment).initInOutUK(YesType.fromUniverse(this.get(inOutUK, i)));
            ((FPSEmploymentEntry)employment).initEeaCitizen(YesType.fromUniverse(this.get(eeaCitizen, i)));
            ((FPSEmploymentEntry)employment).initEpm6(YesType.fromUniverse(this.get(epm6, i)));
            ((FPSEmploymentEntry)employment).initDirectorsNIC(this.get(directorsNIC, i));
            ((FPSEmploymentEntry)employment).initTaxWkOfApptOfDirector(this.get(taxWsOfApptOfDirector, i));
            ((FPSEmploymentEntry)employment).initStartDec(starterDec);
            ((FPSEmploymentEntry)employment).initTaxablePayToDate(this.get(taxablePTD, i));
            ((FPSEmploymentEntry)employment).initTotalTaxToDate(this.get(taxPaid, i));
            ((FPSEmploymentEntry)employment).initStudentLoanRecoveredYTD(this.get(studentLoanRecovered, i));
            ((FPSEmploymentEntry)employment).initTaxDeductionsOrRefunded(this.get(taxDeductionsOrRefunds, i));
            ((FPSEmploymentEntry)employment).initBenefitsTaxedViaPayrollYTD(this.get(benefitsTaxedViaPayrollYTD, i));
            ((FPSEmploymentEntry)employment).initEmpeePenContribnsPaidYTD(this.get(empeePenContribnsPaidYTD, i));
            ((FPSEmploymentEntry)employment).initEmpeePenContribnsNotPaidYTD(this.get(empeePenContribnsNotPaidYTD, i));
            ((FPSEmploymentEntry)employment).initOnStrike(YesType.fromUniverse(this.get(onStrike, i)));
            ((FPSEmploymentEntry)employment).initUnpaidAbsence(YesType.fromUniverse(this.get(unpaidAbsence, i)));
            ((FPSEmploymentEntry)employment).initSmpYTD(this.get(smpYTD, i));
            ((FPSEmploymentEntry)employment).initSapYTD(this.get(sapYTD, i));
            ((FPSEmploymentEntry)employment).initPaymentDate(this.get(paymentDates, i));
            ((FPSEmploymentEntry)employment).initPaymentFrequency(this.get(paymentFrequencies, i));
            ((FPSEmploymentEntry)employment).initWeekNo(this.get(weekNos, i));
            ((FPSEmploymentEntry)employment).initMonthNo(this.get(monthNos, i));
            ((FPSEmploymentEntry)employment).initAggregatedEarnings(YesType.fromUniverse(this.get(aggEarnings, i)));
            ((FPSEmploymentEntry)employment).initPaymentAfterLeaving(YesType.fromUniverse(this.get(paymentAfterLeaving, i)));
            ((FPSEmploymentEntry)employment).initHoursWorked(this.get(hoursWorked, i));
            ((FPSEmploymentEntry)employment).initPeriodsCovered(this.get(periodsCovered, i));
            ((FPSEmploymentEntry)employment).initTaxCode(this.get(taxCodes, i));
            ((FPSEmploymentEntry)employment).initTaxBase(YesType.fromUniverse(this.get(taxBases, i)));
            ((FPSEmploymentEntry)employment).initTaxablePay(this.get(taxablePay, i));
            ((FPSEmploymentEntry)employment).initNonTaxOrNICPmt(this.get(nonTaxOrNICPmt, i));
            ((FPSEmploymentEntry)employment).initDeductionsFromNetPay(this.get(deductionsFromNetPay, i));
            ((FPSEmploymentEntry)employment).initPayAfterStatDeductions(this.get(payAfterStatDeductions, i));
            ((FPSEmploymentEntry)employment).initBenefitsTaxedViaPayroll(this.get(benefitsTaxedViaPayroll, i));
            ((FPSEmploymentEntry)employment).initEmpeePenContribnsPaid(this.get(empeePenContribnsPaid, i));
            ((FPSEmploymentEntry)employment).initItemsSubjectToClass1NIC(this.get(itemsSubjectToClass1NIC, i));
            ((FPSEmploymentEntry)employment).initEmpeePenContribnsNotPaid(this.get(empeePenContribnsNotPaid, i));
            ((FPSEmploymentEntry)employment).initStudentLoanRecovered(this.get(studentLoanTP, i));
            ((FPSEmploymentEntry)employment).initBacsHashCode(this.get(bacsHashes, i));
            ((FPSEmploymentEntry)employment).initOrigSortCode(this.get(origSortCodes, i));
            ((FPSEmploymentEntry)employment).initRecipSortCode(this.get(recipSortCodes, i));
            ((FPSEmploymentEntry)employment).initNetPayment(this.get(netPayments, i));
            ((FPSEmploymentEntry)employment).initIrrEmp(YesType.fromUniverse(this.get(irregularPayments, i)));
            ((FPSEmploymentEntry)employment).initOldPayrollId(this.get(oldPayrollIds, i));
            ((FPSEmploymentEntry)employment).initPayrollIdChangedIndicator(YesType.fromUniverse(this.get(payrollIdChanged, i)));
            employments.add(employment);
        }
        return employments;
    }

    protected <T> T get(List<T> list, int i) {
        return list.size() > i ? (T)list.get(i) : null;
    }

    protected String trim(String value) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return value;
    }
}

