/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.js.builder.entry;

import com.selima.fbi.CancelException;
import com.selima.fbi.core.payebeans.impl.YesType;
import com.selima.fbi.core.payebeans.rti2017.impl.EYUEmploymentEntry2016AndBeyond;
import com.selima.fbi.core.payebeans.rti2018.impl.EYUEmployeeEntry2017Beyond;
import com.selima.fbi.core.payebeans.rti2018.impl.EYUEmploymentEntry2017Beyond;
import com.selima.fbi.core.payebeans.rti2018.impl.EYULettersAndValues2017Beyond;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.js.builder.entry.AbstractEYUEntryBuilder2014Beyond;
import com.selima.fbi.plugin.u2.PayrollDataFormatException;
import com.selima.fbi.plugin.u2.UniverseRPCException;
import com.selima.fbi.plugin.u2.UniverseRecord;
import java.util.List;

abstract class AbstractEYUEntryBuilder2017Beyond<EmployeeEntry extends EYUEmployeeEntry2017Beyond, EmploymentEntry extends EYUEmploymentEntry2017Beyond, LettersAndValues extends EYULettersAndValues2017Beyond>
extends AbstractEYUEntryBuilder2014Beyond<EmployeeEntry, EmploymentEntry, LettersAndValues> {
    private List<String> flexiblyAccessingPensionRights;
    private List<String> pensionDeathBenefits;
    private List<String> taxRegimes;
    private List<Number> grossEarningsForNics;
    private List<Number> nonTaxablePayments;
    private List<Number> taxablePayments;
    private List<Number> ptToUEL;
    private List<Number> shpp;
    private List<Number> spp;

    AbstractEYUEntryBuilder2017Beyond() {
    }

    @Override
    protected List<EmploymentEntry> readEmployements(List<LettersAndValues> niLettersAndValues, UniverseRecord record) throws UniverseRPCException, CancelException, PluginException {
        this.spp = record.readMultivaluedNumbers("OSPP_EYU");
        this.shpp = record.readMultivaluedNumbers("ASPP_EYU");
        this.taxRegimes = record.readMultivaluedStrings("SVR_IND");
        this.taxablePayments = record.readMultivaluedNumbers("FLEX_PEN_TAX_EYU");
        this.nonTaxablePayments = record.readMultivaluedNumbers("FLEX_PEN_NTAX_EYU");
        this.pensionDeathBenefits = record.readMultivaluedStrings("DEATH_BEN_EYU");
        this.flexiblyAccessingPensionRights = record.readMultivaluedStrings("FLEX_PEN_EYU");
        return super.readEmployements(niLettersAndValues, record);
    }

    @Override
    protected List<LettersAndValues> readNILettersAndValues(UniverseRecord universeRecord) throws UniverseRPCException, CancelException, PluginException {
        this.grossEarningsForNics = universeRecord.readMultivaluedNumbers("NI_PAY_EYU");
        this.ptToUEL = universeRecord.readMultivaluedNumbers("TO_UEL_EYU");
        return super.readNILettersAndValues(universeRecord);
    }

    @Override
    protected LettersAndValues newNILettersAndValues(UniverseRecord universeRecord, int index) throws UniverseRPCException, PayrollDataFormatException, CancelException, PluginException {
        LettersAndValues result = this.newLettersAndValues();
        ((EYULettersAndValues2017Beyond)result).initGrossEarningsForNICs(this.get(this.grossEarningsForNics, index));
        ((EYULettersAndValues2017Beyond)result).initPtToUEL(this.get(this.ptToUEL, index));
        return result;
    }

    abstract LettersAndValues newLettersAndValues();

    @Override
    protected EmploymentEntry newEmploymentEntryFrom2014Beyond(List<LettersAndValues> niLettersAndValues, UniverseRecord record, int index) {
        EmploymentEntry employmentEntry = this.newEmploymentEntry(niLettersAndValues);
        ((EYUEmploymentEntry2016AndBeyond)employmentEntry).initSpp(this.get(this.spp, index));
        ((EYUEmploymentEntry2016AndBeyond)employmentEntry).initShpp(this.get(this.shpp, index));
        ((EYUEmploymentEntry2016AndBeyond)employmentEntry).initFlexiblyAccessingPensionRights(YesType.fromUniverse(this.get(this.flexiblyAccessingPensionRights, index)));
        ((EYUEmploymentEntry2017Beyond)employmentEntry).initPensionDeathBenefit(YesType.fromUniverse(this.get(this.pensionDeathBenefits, index)));
        ((EYUEmploymentEntry2017Beyond)employmentEntry).initTaxablePayment(this.get(this.taxablePayments, index));
        ((EYUEmploymentEntry2017Beyond)employmentEntry).initNonTaxablePayment(this.get(this.nonTaxablePayments, index));
        ((EYUEmploymentEntry2017Beyond)employmentEntry).initTaxRegime(this.get(this.taxRegimes, index));
        return employmentEntry;
    }

    abstract EmploymentEntry newEmploymentEntry(List<LettersAndValues> var1);
}

