/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.js.builder.entry;

import com.selima.fbi.CancelException;
import com.selima.fbi.core.YesNoEnum;
import com.selima.fbi.core.payebeans.BeanAddress;
import com.selima.fbi.core.payebeans.impl.AbstractEmployeeEntry;
import com.selima.fbi.core.payebeans.impl.EYUEmployeeEntry;
import com.selima.fbi.core.payebeans.impl.EYUEmploymentEntry;
import com.selima.fbi.core.payebeans.impl.EYULettersAndValues;
import com.selima.fbi.core.payebeans.impl.YesType;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.u2.PayrollDataFormatException;
import com.selima.fbi.plugin.u2.UniverseEntryBuilder;
import com.selima.fbi.plugin.u2.UniverseRPCException;
import com.selima.fbi.plugin.u2.UniverseRecord;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AbstractEYUEntryBuilder<EmployeeType extends EYUEmployeeEntry, EmploymentType extends EYUEmploymentEntry, LettersAndValuesType extends EYULettersAndValues>
implements UniverseEntryBuilder<EmployeeType> {
    String officeNo;
    String payeRef;
    String aoRef;

    public String getOfficeNo() {
        return this.officeNo;
    }

    public String getPayeRef() {
        return this.payeRef;
    }

    public String getAoRef() {
        return this.aoRef;
    }

    protected abstract LettersAndValuesType newNILettersAndValues(UniverseRecord var1, int var2) throws UniverseRPCException, PayrollDataFormatException, CancelException, PluginException;

    protected abstract EmploymentType newEmploymentEntry(List<LettersAndValuesType> var1, UniverseRecord var2, int var3) throws UniverseRPCException, PayrollDataFormatException, CancelException, PluginException;

    protected abstract EmployeeType newEmployeeEntry(List<EmploymentType> var1, UniverseRecord var2) throws UniverseRPCException, PayrollDataFormatException, CancelException, PluginException;

    @Override
    public EmployeeType build(UniverseRecord record) throws PluginException, CancelException {
        this.readMessageLevelValues(record);
        List<LettersAndValuesType> niLettersAndValues = this.readNILettersAndValues(record);
        List<EmploymentType> employements = this.readEmployements(niLettersAndValues, record);
        return this.readEmployee(employements, record);
    }

    protected EmployeeType readEmployee(List<EmploymentType> employements, UniverseRecord record) throws UniverseRPCException, CancelException, PluginException {
        EmployeeType employeeEntry = this.newEmployeeEntry(employements, record);
        ((AbstractEmployeeEntry)employeeEntry).initTitle(record.readString("TITLE"));
        ((AbstractEmployeeEntry)employeeEntry).initFore1(this.trim(record.readString("FORENAME")));
        ((AbstractEmployeeEntry)employeeEntry).initFore2(this.trim(record.readString("SECOND_FORENAME")));
        ((AbstractEmployeeEntry)employeeEntry).initSurname(record.readString("SURNAME"));
        ((AbstractEmployeeEntry)employeeEntry).initNino(record.readString("NINO"));
        ((EYUEmployeeEntry)employeeEntry).initBirthDate(record.readDate("DOB"));
        ((EYUEmployeeEntry)employeeEntry).initGender(record.readString("GENDER"));
        ((EYUEmployeeEntry)employeeEntry).initPassport(record.readString("PASSPORT"));
        ((EYUEmployeeEntry)employeeEntry).initPartnerNino(record.readString("PARTNER_NINO"));
        ((EYUEmployeeEntry)employeeEntry).initPartnerFore1(record.readString("PARTNER_FORENAME"));
        ((EYUEmployeeEntry)employeeEntry).initPartnerFore2(record.readString("PARTNER_SECOND_FORENAME"));
        ((EYUEmployeeEntry)employeeEntry).initPartnerSurname(record.readString("PARTNER_SURNAME"));
        BeanAddress employeeAddress = new BeanAddress(record.readStrings("EMPLOYEE_ADDRESS_LINE1", "EMPLOYEE_ADDRESS_LINE2", "EMPLOYEE_ADDRESS_LINE3", "EMPLOYEE_ADDRESS_LINE4"), record.readString("EMPLOYEE_POSTCODE"), record.readString("FOREIGN_COUNTRY"));
        ((EYUEmployeeEntry)employeeEntry).initAddress(employeeAddress);
        return employeeEntry;
    }

    protected List<EmploymentType> readEmployements(List<LettersAndValuesType> niLettersAndValues, UniverseRecord record) throws UniverseRPCException, CancelException, PluginException {
        List<String> taxCodes = record.readMultivaluedStrings("TAX_CODE");
        List<String> taxBase = record.readMultivaluedStrings("TAX_BASIS");
        List<String> payrollIds = record.readMultivaluedStrings("PAYROLL_ID");
        List<Date> startDates = record.readMultivaluedDates("START_DATE");
        List<Date> leavingDates = record.readMultivaluedDates("LEAVING_DATE");
        List<String> studentLoans = record.readMultivaluedStrings("STUDENT_LOAN");
        List<String> stay183DaysOrMore = record.readMultivaluedStrings("LIVING_IN_UK_MORE");
        List<String> stayLessThen183Days = record.readMultivaluedStrings("LIVING_IN_UK_LESS");
        List<String> inOutUK = record.readMultivaluedStrings("WORKING_IN_AND_OUT_OF_UK");
        List<String> eeaCitizen = record.readMultivaluedStrings("EEA_OR_COMMONWEALTH");
        List<String> epm6 = record.readMultivaluedStrings("EPM6_SCHEME");
        String startDec = record.readString("STARTER_DECLARATION");
        List<Number> taxablePay = record.readMultivaluedNumbers("TAXABLE_PAY_EYU");
        List<Number> studentLoanRecovered = record.readMultivaluedNumbers("STUDENT_LOAN_EYU");
        List<Number> tax = record.readMultivaluedNumbers("INCOME_TAX_EYU");
        List<Number> smp = record.readMultivaluedNumbers("SMP_EYU");
        List<Number> sap = record.readMultivaluedNumbers("SAP_EYU");
        List<Number> occPension = record.readMultivaluedNumbers("AMOUNT_OF_OCC_PENSION");
        ArrayList<EmploymentType> result = new ArrayList<EmploymentType>(taxCodes.size());
        for (int i = 0; i < taxCodes.size(); ++i) {
            EmploymentType employmentEntry = this.newEmploymentEntry(niLettersAndValues, record, i);
            ((EYUEmploymentEntry)employmentEntry).initTaxCode(this.get(taxCodes, i));
            ((EYUEmploymentEntry)employmentEntry).initTaxBase(YesType.fromUniverse(this.get(taxBase, i)));
            ((EYUEmploymentEntry)employmentEntry).initPayId(this.get(payrollIds, i));
            ((EYUEmploymentEntry)employmentEntry).initStartDate(this.get(startDates, i));
            ((EYUEmploymentEntry)employmentEntry).initLeavingDate(this.get(leavingDates, i));
            ((EYUEmploymentEntry)employmentEntry).initStudentLoan(YesType.fromUniverse(this.get(studentLoans, i)));
            ((EYUEmploymentEntry)employmentEntry).initStay183DaysOrMore(YesType.fromUniverse(this.get(stay183DaysOrMore, i)));
            ((EYUEmploymentEntry)employmentEntry).initStayLessThan183Days(YesType.fromUniverse(this.get(stayLessThen183Days, i)));
            ((EYUEmploymentEntry)employmentEntry).initInOutUK(YesType.fromUniverse(this.get(inOutUK, i)));
            ((EYUEmploymentEntry)employmentEntry).initEeaCitizen(YesType.fromUniverse(this.get(eeaCitizen, i)));
            ((EYUEmploymentEntry)employmentEntry).initEpm6(YesType.fromUniverse(this.get(epm6, i)));
            ((EYUEmploymentEntry)employmentEntry).initStartDec(startDec);
            ((EYUEmploymentEntry)employmentEntry).initTaxablePay(this.get(taxablePay, i));
            ((EYUEmploymentEntry)employmentEntry).initStudentLoanRecovered(this.get(studentLoanRecovered, i));
            ((EYUEmploymentEntry)employmentEntry).initTax(this.get(tax, i));
            ((EYUEmploymentEntry)employmentEntry).initSmp(this.get(smp, i));
            ((EYUEmploymentEntry)employmentEntry).initSap(this.get(sap, i));
            ((EYUEmploymentEntry)employmentEntry).initOccPensionAmount(this.get(occPension, i));
            result.add(employmentEntry);
        }
        return result;
    }

    protected List<LettersAndValuesType> readNILettersAndValues(UniverseRecord record) throws UniverseRPCException, CancelException, PluginException {
        List<String> niCategories = record.readMultivaluedStrings("NI_CATEGORY");
        List<Number> atLEL = record.readMultivaluedNumbers("TO_LEL_EYU");
        List<Number> lelToPT = record.readMultivaluedNumbers("TO_PT_EYU");
        List<Number> totalEmpNIC = record.readMultivaluedNumbers("ER_CONTS_EYU");
        List<Number> empeeContribns = record.readMultivaluedNumbers("EE_CONTS_EYU");
        List<String> nicRefunds = record.readMultivaluedStrings("NI_REFUND");
        ArrayList<LettersAndValuesType> result = new ArrayList<LettersAndValuesType>();
        int i = 0;
        for (String niCategory : niCategories) {
            if (niCategory == null) continue;
            LettersAndValuesType lettersAndValues = this.newNILettersAndValues(record, i);
            ((EYULettersAndValues)lettersAndValues).initNiCat(niCategory);
            ((EYULettersAndValues)lettersAndValues).initAtLEL(this.get(atLEL, i));
            ((EYULettersAndValues)lettersAndValues).initLelToPT(this.get(lelToPT, i));
            ((EYULettersAndValues)lettersAndValues).initTotalEmpNIC(this.get(totalEmpNIC, i));
            ((EYULettersAndValues)lettersAndValues).initEmpeeContribns(this.get(empeeContribns, i));
            String nicRefund = this.get(nicRefunds, i);
            if (nicRefund != null) {
                ((EYULettersAndValues)lettersAndValues).initNicRefund("Y".equalsIgnoreCase(nicRefund) ? YesNoEnum.YES : YesNoEnum.NO);
            }
            result.add(lettersAndValues);
            ++i;
        }
        return result;
    }

    protected void readMessageLevelValues(UniverseRecord record) throws UniverseRPCException, CancelException, PluginException {
        if (this.officeNo == null) {
            this.officeNo = record.readString("HMRC_OFFICE_NUMBER");
        }
        if (this.payeRef == null) {
            this.payeRef = record.readString("EMPLOYER_PAYE_REF");
        }
        if (this.aoRef == null) {
            this.aoRef = record.readString("EMPLOYER_ACCOUNTS_OFFICE");
        }
    }

    protected String trim(String value) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return value;
    }

    protected <T> T get(List<T> list, int i) {
        return list.size() > i ? (T)list.get(i) : null;
    }
}

