/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.js;

import com.selima.fbi.CancelException;
import com.selima.fbi.FormType;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IP9Message;
import com.selima.fbi.core.wrapper.DPSMessageWrapper;
import com.selima.fbi.plugin.IPayrollPlugin;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.js.HarmlessDPSPlugin;
import com.selima.fbi.user.PayrollServerSpec;
import java.util.Date;
import java.util.List;

public class HarmlessP9Plugin
extends HarmlessDPSPlugin {
    public HarmlessP9Plugin(IPayrollPlugin plugin) {
        super(plugin);
    }

    @Override
    public void storeDPSMessage(PayrollServerSpec payrollServer, IDPSMessage message, boolean firstInRow) throws PluginException, CancelException {
        if (message.getFormType() == FormType.P9) {
            message = new HarmlessP9Message((IP9Message)message, this.nextHarmlessRecord()).getProxy(IDPSMessage.class);
        }
        super.storeDPSMessage(payrollServer, message, firstInRow);
    }

    static class HarmlessP9Message
    extends DPSMessageWrapper
    implements IP9Message {
        private HarmlessDPSPlugin.HarmlessRecord record;

        HarmlessP9Message(IP9Message message, HarmlessDPSPlugin.HarmlessRecord record) {
            super(message);
            this.record = record;
        }

        @Override
        public String getNino() {
            return this.record.nino;
        }

        @Override
        public Date getEffectiveDate() {
            return this.wrappedP9().getEffectiveDate();
        }

        @Override
        public String getTaxCode() {
            return this.record.taxCode;
        }

        @Override
        public boolean getWeek1Month1Indicator() {
            return this.record.week1Month1Indicator;
        }

        @Override
        public String getWorksNumber() {
            return this.record.worksNumber;
        }

        @Override
        public int getTaxYearEnd() {
            return 2008;
        }

        IP9Message wrappedP9() {
            return (IP9Message)this.wrapped;
        }

        @Override
        public String getSurname() {
            return this.wrappedP9().getSurname();
        }

        @Override
        public List<String> getForename() {
            return this.wrappedP9().getForename();
        }

        @Override
        public String getTaxRegime() {
            return this.wrappedP9().getTaxRegime();
        }
    }
}

