/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin.js;

import com.selima.fbi.plugin.IPayrollPlugin;
import com.selima.fbi.plugin.PayrollPluginWrapper;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.Queue;

public class HarmlessDPSPlugin
extends PayrollPluginWrapper {
    private Queue<HarmlessRecord> queue = new LinkedList<HarmlessRecord>(Arrays.asList(new HarmlessRecord("JZ042612B", "533L", "001576", false), new HarmlessRecord("LE178403D", "K201", "001603", true), new HarmlessRecord("LX378427B", "10L", "001612", false), new HarmlessRecord("NB142760A", "623L", "074624", true))){

        @Override
        public HarmlessRecord remove() {
            HarmlessRecord result = (HarmlessRecord)super.remove();
            this.add(result.updateNumbers());
            return result;
        }
    };

    public HarmlessDPSPlugin(IPayrollPlugin plugin) {
        super(plugin);
    }

    protected HarmlessRecord nextHarmlessRecord() {
        return this.queue.remove();
    }

    protected static class HarmlessRecord
    implements Cloneable {
        static int instanceCounter;
        final String worksNumber;
        final String nino;
        final String taxCode;
        final boolean week1Month1Indicator;
        Number totalPreviousPay;
        Number totalPreviousTax;

        HarmlessRecord(String nino, String taxCode, String worksNumber, boolean week1Month1Indicator) {
            ++instanceCounter;
            this.nino = nino;
            this.taxCode = taxCode;
            this.worksNumber = worksNumber;
            this.week1Month1Indicator = week1Month1Indicator;
            long minutes = this.numberOfMinutesThisMonth();
            this.totalPreviousPay = 5000L + minutes - (long)(10 * instanceCounter);
            this.totalPreviousTax = 1000L + minutes / 5L - (long)instanceCounter;
        }

        private long numberOfMinutesThisMonth() {
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(5, 1);
            long millis = System.currentTimeMillis() - cal.getTimeInMillis();
            long minutes = millis / 60000L;
            return minutes;
        }

        HarmlessRecord updateNumbers() {
            HarmlessRecord clone = this.clone();
            clone.totalPreviousPay = this.totalPreviousPay.intValue() - 1000;
            clone.totalPreviousTax = this.totalPreviousTax.intValue() - 200;
            return clone;
        }

        public HarmlessRecord clone() {
            try {
                return (HarmlessRecord)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

