/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.plugin;

import com.selima.fbi.plugin.PluginException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class PluginChainableException
extends PluginException {
    Map<String, List<String>> errors = new HashMap<String, List<String>>();
    static final int LIMIT = 4;

    public PluginChainableException(String server, String[] errors) {
        super((String)null);
        this.errors.put(server, new ArrayList<String>(Arrays.asList(errors)));
    }

    @Override
    public String getMessage() {
        return PluginChainableException.firstFewToText(new MultiListIterator<String>(this.errors.values()));
    }

    public String getHtmlMessage() {
        return PluginChainableException.firstFewToHTML(new MultiListIterator<String>(this.errors.values()), this.getNumOfErrors());
    }

    public int getNumOfErrors() {
        int result = 0;
        for (List<String> list : this.errors.values()) {
            result += list.size();
        }
        return result;
    }

    public Iterable<String> getServers() {
        return new HashSet<String>(this.errors.keySet());
    }

    public List<String> getErrors(String server) {
        return new ArrayList<String>((Collection)this.errors.get(server));
    }

    public void chain(PluginChainableException e) {
        for (String server : e.getServers()) {
            List<String> currentList = this.errors.get(server);
            List<String> additionList = e.errors.get(server);
            if (currentList == null) {
                this.errors.put(server, additionList);
                continue;
            }
            currentList.addAll(additionList);
        }
    }

    static String firstFewToText(Iterator<String> errors) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < 4 && errors.hasNext(); ++i) {
            result.append(errors.next()).append("\n");
        }
        return result.toString();
    }

    static String firstFewToHTML(Iterator<String> errors, int size) {
        StringBuilder result = new StringBuilder().append("<html><ul style='margin-left:8px;color:olive;'>");
        for (int i = 0; i < 4 && errors.hasNext(); ++i) {
            result.append("<li>").append(errors.next()).append("</li>");
        }
        if (size > 4) {
            result.append("<li>").append(size - 4).append(" more errors").append("</li>");
        }
        return result.append("</ul></html>").toString();
    }

    static class MultiListIterator<T>
    implements Iterator<T> {
        Iterator<List<T>> lists;
        Iterator<T> it;

        MultiListIterator(Collection<List<T>> lists) {
            this.lists = lists.iterator();
        }

        @Override
        public boolean hasNext() {
            this.moveOverLists();
            return this.it != null && this.it.hasNext();
        }

        @Override
        public T next() {
            this.moveOverLists();
            if (this.it != null) {
                return this.it.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void moveOverLists() {
            if ((this.it == null || !this.it.hasNext()) && this.lists.hasNext()) {
                this.it = this.lists.next().iterator();
            }
        }
    }
}

