/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.loader;

import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.standard.eoy2013.EOY2013Message;
import com.selima.fbi.core.standard.eoy2013.P14Part2013Message;
import com.selima.fbi.core.standard.eoy2013.P35Part2013Message;
import com.selima.fbi.core.standard.generated.paye2013.IRenvelope;
import com.selima.fbi.loader.PAYEMessageFactory;

class PAYE2013MessageFactory
implements PAYEMessageFactory<IRenvelope> {
    PAYE2013MessageFactory() {
    }

    @Override
    public IPAYEMessage create(IRenvelope envelope, byte[] bytes) {
        String submission = envelope.getEndOfYearReturn().getSubmissionType();
        if ("complete".equals(submission)) {
            return new EOY2013Message(envelope, bytes);
        }
        if ("P14Part".equals(submission)) {
            return new P14Part2013Message(envelope, bytes);
        }
        if ("P35Part".equals(submission)) {
            return new P35Part2013Message(envelope, bytes);
        }
        throw new IllegalStateException(submission);
    }

    @Override
    public Class<IRenvelope> getEnvelopeType() {
        return IRenvelope.class;
    }
}

