/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.loader;

import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.standard.eoy2010.EOY2010Message;
import com.selima.fbi.core.standard.eoy2010.P14Part2010Message;
import com.selima.fbi.core.standard.eoy2010.P35Part2010Message;
import com.selima.fbi.core.standard.generated.paye2010.IRenvelope;
import com.selima.fbi.loader.PAYEMessageFactory;

class PAYE2010MessageFactory
implements PAYEMessageFactory<IRenvelope> {
    PAYE2010MessageFactory() {
    }

    @Override
    public IPAYEMessage create(IRenvelope envelope, byte[] bytes) {
        String submission = envelope.getEndOfYearReturn().getSubmissionType();
        if ("complete".equals(submission)) {
            return new EOY2010Message(envelope, bytes);
        }
        if ("P14Part".equals(submission)) {
            return new P14Part2010Message(envelope, bytes);
        }
        if ("P35Part".equals(submission)) {
            return new P35Part2010Message(envelope, bytes);
        }
        throw new IllegalStateException(submission);
    }

    @Override
    public Class<IRenvelope> getEnvelopeType() {
        return IRenvelope.class;
    }
}

