/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.loader;

import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.standard.generated.mov2006.IRenvelope;
import com.selima.fbi.core.standard.mov2006.P45Part1Message2006;
import com.selima.fbi.core.standard.mov2006.P45Part3Message2006;
import com.selima.fbi.core.standard.mov2006.P46Message2006;
import com.selima.fbi.core.standard.mov2006.PENNOTMessage;
import com.selima.fbi.loader.PAYEMessageFactory;

public class Mov2006MessageFactory
implements PAYEMessageFactory<IRenvelope> {
    @Override
    public IPAYEMessage create(IRenvelope envelope, byte[] bytes) {
        if (envelope.getInYearMovements().getP45Part1s().size() > 0) {
            return new P45Part1Message2006(envelope, bytes);
        }
        if (envelope.getInYearMovements().getP45Part3s().size() > 0) {
            return new P45Part3Message2006(envelope, bytes);
        }
        if (envelope.getInYearMovements().getP46S().size() > 0) {
            return new P46Message2006(envelope, bytes);
        }
        if (envelope.getInYearMovements().getPensionNotifications().size() > 0) {
            return new PENNOTMessage(envelope, bytes);
        }
        throw new IllegalArgumentException("Unsupported message type: " + new String(bytes));
    }

    @Override
    public Class<IRenvelope> getEnvelopeType() {
        return IRenvelope.class;
    }
}

