/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.loader;

import com.selima.fbi.ArchiveDetails;
import com.selima.fbi.MalformedMessage;
import com.selima.fbi.State;
import com.selima.fbi.TransferDetails;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.PAYESubmissionDetails;
import com.selima.fbi.core.response.IStorableResponse;
import com.selima.fbi.gotvalue.GotValueImpl;
import com.selima.fbi.loader.CombinedResponseLoader;
import com.selima.fbi.loader.DPSMessageLoader;
import com.selima.fbi.loader.GenericJAXBLoader;
import com.selima.fbi.loader.ILoader;
import com.selima.fbi.loader.ILoaderFactory;
import com.selima.fbi.loader.MalformedMessageLoader;
import com.selima.fbi.loader.PAYEMessageBodyLoader;
import com.selima.fbi.loader.PAYESubmissionDetailsLoader;
import com.selima.fbi.loader.StateLoader;
import com.selima.fbi.loader.StorableIDLoader;
import com.selima.fbi.loader.StorablePropertiesLoader;
import com.selima.fbi.loader.StorableRevisionLoader;
import com.selima.fbi.loader.UserLoader;
import com.selima.fbi.sender.SenderDetailsImpl;
import com.selima.fbi.sender.StorableID;
import com.selima.fbi.storage.IStorable;
import com.selima.fbi.storage.migration.StorableRevision;
import com.selima.fbi.storage.transfer.RawRecord;
import com.selima.fbi.storage.transfer.RawRecordLoader;
import com.selima.fbi.typed.StorableProperties;
import com.selima.fbi.user.DefaultServerSpec;
import com.selima.fbi.user.FullReference;
import com.selima.fbi.user.UserImpl;

public class LoaderFactory
implements ILoaderFactory {
    @Override
    public <T extends IStorable> ILoader<T> createLoader(Class<T> type) {
        if (IDPSMessage.class == type) {
            return new DPSMessageLoader();
        }
        if (IPAYEMessage.class == type) {
            return new PAYEMessageBodyLoader();
        }
        if (UserImpl.class == type) {
            return new UserLoader();
        }
        if (SenderDetailsImpl.class == type) {
            return new GenericJAXBLoader<T>(type);
        }
        if (GotValueImpl.class == type) {
            return new GenericJAXBLoader<T>(type);
        }
        if (State.class == type) {
            return new StateLoader();
        }
        if (MalformedMessage.class == type) {
            return new MalformedMessageLoader();
        }
        if (PAYESubmissionDetails.class == type) {
            return new PAYESubmissionDetailsLoader();
        }
        if (IStorableResponse.class == type) {
            return new CombinedResponseLoader();
        }
        if (StorableID.class == type) {
            return new StorableIDLoader();
        }
        if (StorableProperties.class == type) {
            return new StorablePropertiesLoader();
        }
        if (FullReference.class == type) {
            return new GenericJAXBLoader<T>(type);
        }
        if (DefaultServerSpec.class == type) {
            return new GenericJAXBLoader<T>(type);
        }
        if (StorableRevision.class == type) {
            return new StorableRevisionLoader();
        }
        if (ArchiveDetails.class == type) {
            return new GenericJAXBLoader<T>(type);
        }
        if (TransferDetails.class == type) {
            return new GenericJAXBLoader<T>(type);
        }
        if (RawRecord.class == type) {
            return new RawRecordLoader();
        }
        throw new IllegalArgumentException(type + " not supported");
    }
}

