/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.loader;

import com.selima.fbi.loader.ILoader;
import com.selima.fbi.storage.IStorable;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class GenericJAXBLoader<T extends IStorable>
implements ILoader<T> {
    private Unmarshaller unmarshaller;
    private Class<T> type;

    public GenericJAXBLoader(Class<T> type) {
        try {
            this.type = type;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{type});
            this.unmarshaller = jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public T load(InputStream stream) throws IOException {
        try {
            return (T)((IStorable)this.type.cast(this.unmarshaller.unmarshal(stream)));
        }
        catch (JAXBException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }
}

