/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.crypto;

import com.selima.fbi.crypto.Buffer;
import com.selima.fbi.crypto.IBytesTransformation;
import com.selima.fbi.crypto.TransformingBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class TransformingInputStream
extends InputStream {
    InputStream wrappedStream;
    Buffer encodedBuffer;
    TransformingBuffer decodedBuffer;
    boolean eof = false;

    public TransformingInputStream(InputStream inputStream, IBytesTransformation transformation) {
        this.wrappedStream = inputStream;
        this.encodedBuffer = new Buffer();
        this.decodedBuffer = new TransformingBuffer(transformation);
    }

    @Override
    public int available() throws IOException {
        if (this.decodedBuffer.canGive() == 0) {
            this.decodedBuffer.feedFrom(this.encodedBuffer);
        }
        return this.decodedBuffer.canGive();
    }

    @Override
    public void close() throws IOException {
        if (this.wrappedStream != null) {
            this.wrappedStream.close();
            this.decodedBuffer = null;
            this.encodedBuffer = null;
            this.wrappedStream = null;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(ByteBuffer.wrap(b));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(ByteBuffer.wrap(b, off, len));
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too big skip:" + n);
        }
        int skipped = 0;
        while ((long)skipped < n) {
            if (this.decodedBuffer.canGive() == 0) {
                if (this.eof && this.encodedBuffer.canGive() <= 0) break;
                this.fetchMoreBytes();
            }
            skipped += this.decodedBuffer.skip((int)n - skipped);
        }
        return skipped;
    }

    @Override
    public int read() throws IOException {
        if (this.decodedBuffer.canGive() == 0) {
            this.fetchMoreBytes();
        }
        if (this.decodedBuffer.canGive() > 0) {
            return this.decodedBuffer.giveByte();
        }
        return -1;
    }

    private int read(ByteBuffer output) throws IOException {
        int start_position = output.position();
        while (output.remaining() > 0) {
            if (this.decodedBuffer.canGive() == 0) {
                if (this.eof && this.encodedBuffer.canGive() <= 0) break;
                this.fetchMoreBytes();
            }
            this.decodedBuffer.giveTo(output);
        }
        return output.position() - start_position > 0 ? output.position() - start_position : -1;
    }

    private void fetchMoreBytes() throws IOException {
        while (true) {
            if (this.eof) {
                this.decodedBuffer.feedLastBitsFrom(this.encodedBuffer);
                break;
            }
            if (!this.decodedBuffer.feedFrom(this.encodedBuffer) || this.decodedBuffer.canFeed() <= 0) break;
            this.eof = this.encodedBuffer.feedFrom(this.wrappedStream);
        }
    }
}

