/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.crypto;

import com.selima.fbi.crypto.Base64;
import com.selima.fbi.crypto.CipherSource;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

public class CryptoUtil {
    public static String encrypt(String str) {
        try {
            Cipher encoder = CipherSource.createEncodingCipher();
            return Base64.encodeBytes(encoder.doFinal(str.getBytes("UTF8")));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String decrypt(String str) {
        try {
            Cipher decoder = CipherSource.createDecodingCipher();
            return new String(decoder.doFinal(Base64.decode(str)), "UTF8");
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void main(String[] args) {
        String usage = "CryptoUtil Coder Utility: \n  usage: com.selima.fbi.crypto.CryptoUtil -encode|-decode <string>\n\n";
        if (args.length != 2) {
            System.out.println(usage);
            System.exit(1);
        }
        if ("-encode".equals(args[0])) {
            System.out.println(CryptoUtil.encrypt(args[1]));
        } else if ("-decode".equals(args[0])) {
            System.out.println(CryptoUtil.decrypt(args[1]));
        } else {
            System.out.println(usage);
            System.exit(2);
        }
    }
}

