/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.crypto;

import com.selima.fbi.crypto.IBytesTransformation;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

class CipherTransformation
implements IBytesTransformation {
    private Cipher cipher;

    CipherTransformation(Cipher cipher) {
        this.cipher = cipher;
    }

    @Override
    public int getOutputSize(int inputSize) {
        return this.cipher.getOutputSize(inputSize);
    }

    @Override
    public void transform(ByteBuffer src, ByteBuffer dst) throws IOException {
        try {
            this.cipher.update(src, dst);
        }
        catch (GeneralSecurityException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public void transformLastBytes(ByteBuffer src, ByteBuffer dst) throws IOException {
        try {
            this.cipher.doFinal(src, dst);
        }
        catch (GeneralSecurityException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }
}

