/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.crypto;

import com.selima.fbi.crypto.IBytesTransformation;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.codec.binary.Base64;

class Base64EncoderTransformation
implements IBytesTransformation {
    byte[] lastBytes = new byte[2];
    int numOfLastBytes = 0;

    Base64EncoderTransformation() {
    }

    @Override
    public int getOutputSize(int inputSize) {
        return 4 * ((inputSize + this.numOfLastBytes + 2) / 3);
    }

    @Override
    public void transform(ByteBuffer src, ByteBuffer dst) throws IOException {
        if (src.remaining() == 0) {
            return;
        }
        byte[] buffer = new byte[3 * ((this.numOfLastBytes + src.remaining()) / 3)];
        System.arraycopy(this.lastBytes, 0, buffer, 0, this.numOfLastBytes);
        src.get(buffer, this.numOfLastBytes, buffer.length - this.numOfLastBytes);
        dst.put(Base64.encodeBase64((byte[])buffer, (boolean)false));
        this.numOfLastBytes = src.remaining();
        src.get(this.lastBytes, 0, this.numOfLastBytes);
    }

    @Override
    public void transformLastBytes(ByteBuffer src, ByteBuffer dst) throws IOException {
        byte[] buffer = new byte[this.numOfLastBytes + src.remaining()];
        System.arraycopy(this.lastBytes, 0, buffer, 0, this.numOfLastBytes);
        src.get(buffer, this.numOfLastBytes, src.remaining());
        dst.put(Base64.encodeBase64((byte[])buffer));
        this.numOfLastBytes = 0;
    }
}

