/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.crypto;

import com.selima.fbi.crypto.IBytesTransformation;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.codec.binary.Base64;

class Base64DecoderTransformation
implements IBytesTransformation {
    byte[] lastBytes = new byte[3];
    int numOfLastBytes;

    Base64DecoderTransformation() {
    }

    @Override
    public int getOutputSize(int inputSize) {
        return 3 * ((inputSize + this.numOfLastBytes + 3) / 4);
    }

    @Override
    public void transform(ByteBuffer src, ByteBuffer dst) throws IOException {
        byte[] buffer = new byte[4 * ((src.remaining() + this.numOfLastBytes) / 4)];
        System.arraycopy(this.lastBytes, 0, buffer, 0, this.numOfLastBytes);
        src.get(buffer, this.numOfLastBytes, buffer.length - this.numOfLastBytes);
        dst.put(Base64.decodeBase64((byte[])buffer));
        this.numOfLastBytes = src.remaining();
        src.get(this.lastBytes, 0, this.numOfLastBytes);
    }

    @Override
    public void transformLastBytes(ByteBuffer src, ByteBuffer dst) throws IOException {
        byte[] buffer = new byte[this.numOfLastBytes + src.remaining()];
        System.arraycopy(this.lastBytes, 0, buffer, 0, this.numOfLastBytes);
        src.get(buffer, this.numOfLastBytes, src.remaining());
        dst.put(Base64.decodeBase64((byte[])buffer));
        this.numOfLastBytes = 0;
    }
}

