/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.wrapper;

import com.selima.fbi.FormType;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.core.wrapper.MessageProxy;
import com.selima.fbi.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.Set;

public class AbstractMessageWrapper<MessageType extends IMailMessage>
implements IMailMessage,
InvocationHandler {
    private static final Method OBJECT_EQUALS_METHOD;
    private static final Method MESSAGE_PROXY_GET_PROXIED_METHOD;
    protected MessageType proxy;
    protected MessageType wrapped;

    public AbstractMessageWrapper(MessageType message, Class<MessageType> messageType) {
        if (messageType == null || !messageType.isInterface()) {
            throw new IllegalArgumentException(String.valueOf(messageType));
        }
        this.wrapped = message;
        Set<Class<?>> ifaces = ReflectionUtil.getInterfacesSet(this.wrapped);
        ifaces.addAll(ReflectionUtil.getInterfacesSet(this.getClass()));
        ifaces.add(MessageProxy.class);
        this.proxy = (IMailMessage)messageType.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), ifaces.toArray(new Class[ifaces.size()]), (InvocationHandler)this));
    }

    public MessageType getProxy() {
        return this.proxy;
    }

    public <T> T getProxy(Class<T> type) {
        return type.cast(this.proxy);
    }

    @Override
    public String getNamespace() {
        return this.wrapped.getNamespace();
    }

    @Override
    public byte[] getBytes() throws IOException {
        return this.wrapped.getBytes();
    }

    @Override
    public byte[] getBytesForTransmission() throws IOException {
        return this.wrapped.getBytesForTransmission();
    }

    @Override
    public String getEmpRef() {
        return this.wrapped.getEmpRef();
    }

    @Override
    public FormType getFormType() {
        return this.wrapped.getFormType();
    }

    @Override
    public Date getIssueDate() {
        return this.wrapped.getIssueDate();
    }

    @Override
    public String getSubject() {
        return this.wrapped.getSubject();
    }

    @Override
    public String getStoreId() {
        return this.wrapped.getStoreId();
    }

    @Override
    public String getStoreSpace() {
        return this.wrapped.getStoreSpace();
    }

    @Override
    public int getTaxYearEnd() {
        return this.wrapped.getTaxYearEnd();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (MESSAGE_PROXY_GET_PROXIED_METHOD.equals(method)) {
                return this;
            }
            if (OBJECT_EQUALS_METHOD.equals(method)) {
                if (args[0] != null && Proxy.isProxyClass(args[0].getClass())) {
                    args[0] = Proxy.getInvocationHandler(args[0]);
                }
                return method.invoke((Object)this, args);
            }
            if (method.getDeclaringClass().isAssignableFrom(this.getClass())) {
                return method.invoke((Object)this, args);
            }
            return method.invoke(this.wrapped, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    static {
        try {
            OBJECT_EQUALS_METHOD = Object.class.getMethod("equals", Object.class);
            MESSAGE_PROXY_GET_PROXIED_METHOD = MessageProxy.class.getMethod("getProxied", new Class[0]);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }
}

