/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.core.standard.rti2014;

import com.selima.fbi.FormType;
import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.core.Agent;
import com.selima.fbi.core.Contact;
import com.selima.fbi.core.IFPSMessage;
import com.selima.fbi.core.standard.AbstractPAYEMessage;
import com.selima.fbi.core.standard.generated.fps2014.IRenvelope;
import com.selima.fbi.core.standard.generated.fps2014.IRheader;
import java.util.Map;

public class FPSMessage2014
extends AbstractPAYEMessage<IRenvelope>
implements IFPSMessage {
    private final int employeeCount;

    public FPSMessage2014(IRenvelope envelope, byte[] bytes) {
        super(envelope, "http://www.govtalk.gov.uk/taxation/PAYE/RTI/FullPaymentSubmission/13-14/2", bytes);
        this.employeeCount = this.mapEmployeeCount(envelope);
    }

    @Override
    public int getCount() {
        return this.employeeCount;
    }

    protected int mapEmployeeCount(IRenvelope envelope) {
        return envelope.getFullPaymentSubmission().getEmployees().size();
    }

    @Override
    protected FormType mapFormType(IRenvelope parsedMessage) {
        return FormType.FPS;
    }

    @Override
    protected void getKeys(IRenvelope envelope, Map<String, String> keyMap) {
        for (IRheader.Keys.Key key : envelope.getIRheader().getKeys().getKeies()) {
            keyMap.put(key.getType(), key.getValue());
        }
    }

    @Override
    protected boolean mapTestMessage(IRenvelope envelope) {
        return MailServiceConfig.isDevelopmentVersion();
    }

    @Override
    protected Contact mapPrincipal(IRenvelope envelope) {
        if (envelope.getIRheader().getPrincipal() != null) {
            return new Contact(envelope.getIRheader().getPrincipal().getContact());
        }
        return null;
    }

    @Override
    protected String mapSender(IRenvelope envelope) {
        return envelope.getIRheader().getSender();
    }

    @Override
    protected Agent mapAgent(IRenvelope envelope) {
        if (envelope.getIRheader().getAgent() != null) {
            return new Agent(envelope.getIRheader().getAgent());
        }
        return null;
    }

    @Override
    protected int mapTaxYearEnd(IRenvelope envelope) {
        return envelope.getIRheader().getPeriodEnd().getYear();
    }

    @Override
    protected final String mapSubject(IRenvelope envelope) {
        return null;
    }
}

